/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.util.function.BiFunction;
import org.apache.camel.component.infinispan.InfinispanOperation;
import org.apache.camel.component.infinispan.InfinispanQueryBuilder;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;

public abstract class InfinispanConfiguration {
    @UriParam(label="producer", defaultValue="PUT", description="The operation to perform")
    private InfinispanOperation operation = InfinispanOperation.PUT;
    @UriParam(label="producer", description="Set a specific key for producer operations")
    private Object key;
    @UriParam(label="producer", description="Set a specific value for producer operations")
    private Object value;
    @UriParam(label="producer", description="Set a specific old value for some producer operations")
    private Object oldValue;
    @UriParam(label="producer", description="Set a specific default value for some producer operations")
    private Object defaultValue;
    @UriParam(label="advanced", description="An implementation specific URI for the CacheManager")
    @Metadata(supportFileReference=true)
    private String configurationUri;
    @UriParam(label="advanced", description="Store the operation result in a header instead of the message body. By default,\nresultHeader == null and the query result is stored in the message body, any \nexisting content in the message body is discarded. If resultHeader is set, the \nvalue is used as the name of the header to store the query result and the original \nmessage body is preserved. This value can be overridden by an in message header \nnamed: CamelInfinispanOperationResultHeader")
    private String resultHeader;
    @UriParam(label="advanced", description="Set a specific remappingFunction to use in a compute operation.")
    private BiFunction remappingFunction;
    @UriParam(description="Specifies the query builder.")
    private InfinispanQueryBuilder queryBuilder;

    public InfinispanOperation getOperation() {
        return this.operation;
    }

    public void setOperation(InfinispanOperation operation) {
        this.operation = operation;
    }

    public InfinispanOperation getOperationOrDefault() {
        return this.operation != null ? this.operation : InfinispanOperation.PUT;
    }

    public String getConfigurationUri() {
        return this.configurationUri;
    }

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }

    public String getResultHeader() {
        return this.resultHeader;
    }

    public void setResultHeader(String resultHeader) {
        this.resultHeader = resultHeader;
    }

    public BiFunction getRemappingFunction() {
        return this.remappingFunction;
    }

    public void setRemappingFunction(BiFunction remappingFunction) {
        this.remappingFunction = remappingFunction;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public InfinispanQueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public void setQueryBuilder(InfinispanQueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public boolean hasQueryBuilder() {
        return this.queryBuilder != null;
    }
}

