/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.security.SecureRandom;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.infinispan.InfinispanOperation;
import org.apache.camel.util.CollectionHelper;
import org.awaitility.Awaitility;
import org.infinispan.commons.api.BasicCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public interface InfinispanProducerTestSupport {
    public static final String KEY_ONE = "keyOne";
    public static final String VALUE_ONE = "valueOne";
    public static final String KEY_TWO = "keyTwo";
    public static final String VALUE_TWO = "valueTwo";
    public static final String COMMAND_VALUE = "commandValue";
    public static final String COMMAND_KEY = "commandKey1";
    public static final long LIFESPAN_TIME = 300L;
    public static final long LIFESPAN_FOR_MAX_IDLE = -1L;
    public static final long MAX_IDLE_TIME = 500L;

    public static void wait(long timout, Callable<Boolean> condition) {
        Awaitility.await().atMost(timout, TimeUnit.MILLISECONDS).until(condition);
    }

    public static void wait(long delay, long timout, Callable<Boolean> condition) {
        long jitter = 50 + new SecureRandom().nextInt(50);
        Awaitility.await().pollDelay(delay + jitter, TimeUnit.MILLISECONDS).atMost(timout, TimeUnit.MILLISECONDS).until(condition);
    }

    public BasicCache<Object, Object> getCache();

    public BasicCache<Object, Object> getCache(String var1);

    public ProducerTemplate template();

    public FluentProducerTemplate fluentTemplate();

    @Test
    default public void keyAndValueArePublishedWithDefaultOperation() {
        this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).send();
        Object value = this.getCache().get((Object)KEY_ONE);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)value.toString());
    }

    @Test
    default public void cacheSizeTest() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        this.getCache().put((Object)KEY_TWO, (Object)VALUE_TWO);
        Integer cacheSize = (Integer)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.SIZE).request(Integer.class);
        Assertions.assertEquals((Integer)cacheSize, (Integer)2);
    }

    @Test
    default public void publishKeyAndValueByExplicitlySpecifyingTheOperation() {
        this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUT).send();
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
    }

    @Test
    default public void publishKeyAndValueAsync() throws Exception {
        Assertions.assertTrue((boolean)this.getCache().isEmpty());
        ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUTASYNC).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
    }

    @Test
    default public void publishKeyAndValueAsyncWithLifespan() throws Exception {
        Assertions.assertTrue((boolean)this.getCache().isEmpty());
        ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUTASYNC).withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanLifespanTime", (Object)300L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
        InfinispanProducerTestSupport.wait(300L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE));
    }

    @Test
    default public void publishKeyAndValueAsyncWithLifespanAndMaxIdle() throws Exception {
        Assertions.assertTrue((boolean)this.getCache().isEmpty());
        ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUTASYNC).withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanLifespanTime", (Object)-1L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanMaxIdleTime", (Object)500L).withHeader("CamelInfinispanMaxIdleTimeUnit", (Object)TimeUnit.MILLISECONDS).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
        InfinispanProducerTestSupport.wait(500L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE));
    }

    @Test
    default public void publishMapNormal() {
        this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanMap", (Object)CollectionHelper.mapOf((Object)KEY_ONE, (Object)VALUE_ONE, (Object[])new Object[]{KEY_TWO, VALUE_TWO})).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUTALL).send();
        Assertions.assertEquals((int)2, (int)this.getCache().size());
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_TWO));
    }

    @Test
    default public void publishMapWithLifespan() {
        this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanMap", (Object)CollectionHelper.mapOf((Object)KEY_ONE, (Object)VALUE_ONE, (Object[])new Object[]{KEY_TWO, VALUE_TWO})).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUTALL).withHeader("CamelInfinispanLifespanTime", (Object)300L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).send();
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_TWO));
        InfinispanProducerTestSupport.wait(300L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE) && !this.getCache().containsKey((Object)KEY_TWO));
    }

    @Test
    default public void publishMapWithLifespanAndMaxIdleTime() {
        this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanMap", (Object)CollectionHelper.mapOf((Object)KEY_ONE, (Object)VALUE_ONE, (Object[])new Object[]{KEY_TWO, VALUE_TWO})).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUTALL).withHeader("CamelInfinispanLifespanTime", (Object)-1L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanMaxIdleTime", (Object)500L).withHeader("CamelInfinispanMaxIdleTimeUnit", (Object)TimeUnit.MILLISECONDS).send();
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_TWO));
        InfinispanProducerTestSupport.wait(500L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE) && !this.getCache().containsKey((Object)KEY_TWO));
    }

    @Test
    default public void publishMapNormalAsync() throws Exception {
        ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanMap", (Object)CollectionHelper.mapOf((Object)KEY_ONE, (Object)VALUE_ONE, (Object[])new Object[]{KEY_TWO, VALUE_TWO})).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUTALLASYNC).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_TWO));
    }

    @Test
    default public void publishMapWithLifespanAsync() throws Exception {
        ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanMap", (Object)CollectionHelper.mapOf((Object)KEY_ONE, (Object)VALUE_ONE, (Object[])new Object[]{KEY_TWO, VALUE_TWO})).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUTALLASYNC).withHeader("CamelInfinispanLifespanTime", (Object)300L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_TWO));
        InfinispanProducerTestSupport.wait(300L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE) && !this.getCache().containsKey((Object)KEY_TWO));
    }

    @Test
    default public void publishMapWithLifespanAndMaxIdleTimeAsync() throws Exception {
        ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanMap", (Object)CollectionHelper.mapOf((Object)KEY_ONE, (Object)VALUE_ONE, (Object[])new Object[]{KEY_TWO, VALUE_TWO})).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUTALLASYNC).withHeader("CamelInfinispanLifespanTime", (Object)-1L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanMaxIdleTime", (Object)500L).withHeader("CamelInfinispanMaxIdleTimeUnit", (Object)TimeUnit.MILLISECONDS).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_TWO));
        InfinispanProducerTestSupport.wait(500L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE) && !this.getCache().containsKey((Object)KEY_TWO));
    }

    @Test
    default public void putIfAbsentAlreadyExists() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUTIFABSENT).send();
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
        Assertions.assertEquals((int)1, (int)this.getCache().size());
    }

    @Test
    default public void putIfAbsentNotExists() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_TWO).withHeader("CamelInfinispanValue", (Object)VALUE_TWO).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUTIFABSENT).send();
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_TWO));
        Assertions.assertEquals((int)2, (int)this.getCache().size());
    }

    @Test
    default public void putIfAbsentKeyAndValueAsync() throws Exception {
        ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUTIFABSENTASYNC).request(CompletableFuture.class)).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
    }

    @Test
    default public void putIfAbsentKeyAndValueAsyncWithLifespan() throws Exception {
        ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUTIFABSENTASYNC).withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanLifespanTime", (Object)300L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
        InfinispanProducerTestSupport.wait(300L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE));
    }

    @Test
    default public void putIfAbsentKeyAndValueAsyncWithLifespanAndMaxIdle() throws Exception {
        ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUTIFABSENTASYNC).withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanLifespanTime", (Object)-1L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanMaxIdleTime", (Object)500L).withHeader("CamelInfinispanMaxIdleTimeUnit", (Object)TimeUnit.MILLISECONDS).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
        Thread.sleep(1000L);
        Assertions.assertFalse((boolean)this.getCache().containsKey((Object)KEY_ONE));
    }

    @Test
    default public void notContainsKeyTest() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        boolean result = (Boolean)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_TWO).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.CONTAINSKEY).request(Boolean.class);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    default public void containsKeyTest() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        boolean result = (Boolean)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.CONTAINSKEY).request(Boolean.class);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    default public void notContainsValueTest() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        boolean result = (Boolean)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanValue", (Object)VALUE_TWO).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.CONTAINSVALUE).request(Boolean.class);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    default public void containsValueTest() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        boolean result = (Boolean)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.CONTAINSVALUE).request(Boolean.class);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    default public void publishKeyAndValueWithLifespan() {
        this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanLifespanTime", (Object)300L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUT).send();
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE).toString());
        InfinispanProducerTestSupport.wait(300L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE));
    }

    @Test
    default public void getOrDefault() {
        this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUT).send();
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
        String result1 = (String)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanDefaultValue", (Object)"defaultTest").withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.GETORDEFAULT).request(String.class);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)result1);
        String result2 = (String)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_TWO).withHeader("CamelInfinispanDefaultValue", (Object)"defaultTest").withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.GETORDEFAULT).request(String.class);
        Assertions.assertEquals((Object)"defaultTest", (Object)result2);
    }

    @Test
    default public void putOperationReturnsThePreviousValue() {
        this.getCache().put((Object)KEY_ONE, (Object)"existing value");
        String result = (String)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUT).request(String.class);
        Assertions.assertEquals((Object)"existing value", (Object)result);
    }

    @Test
    default public void computeOperation() {
        this.getCache().put((Object)KEY_ONE, (Object)"existing value");
        String result = (String)this.fluentTemplate().to("direct:compute").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.COMPUTE).request(String.class);
        Assertions.assertEquals((Object)"existing valuereplay", (Object)result);
    }

    @Test
    default public void computeAsyncOperation() throws Exception {
        this.getCache().put((Object)KEY_ONE, (Object)"existing value");
        CompletableFuture result = (CompletableFuture)this.fluentTemplate().to("direct:compute").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.COMPUTEASYNC).request(CompletableFuture.class);
        Assertions.assertEquals((Object)"existing valuereplay", result.get());
    }

    @Test
    default public void retrievesAValueByKey() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        String result = (String)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.GET).request(String.class);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)result);
    }

    @Test
    default public void replaceAValueByKey() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        String result = (String)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_TWO).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REPLACE).request(String.class);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)result);
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_ONE));
    }

    @Test
    default public void replaceAValueByKeyWithLifespan() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        Object result = this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_TWO).withHeader("CamelInfinispanLifespanTime", (Object)300L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REPLACE).request(String.class);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)result);
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_ONE));
        InfinispanProducerTestSupport.wait(300L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE));
    }

    @Test
    default public void replaceAValueByKeyWithLifespanAndMaxIdleTime() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        Object result = this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_TWO).withHeader("CamelInfinispanLifespanTime", (Object)-1L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanMaxIdleTime", (Object)500L).withHeader("CamelInfinispanMaxIdleTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REPLACE).request(String.class);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)result);
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_ONE));
        InfinispanProducerTestSupport.wait(500L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE));
    }

    @Test
    default public void replaceAValueByKeyWithOldValue() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        Boolean result = (Boolean)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_TWO).withHeader("CamelInfinispanOldValue", (Object)VALUE_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REPLACE).request(Boolean.class);
        Assertions.assertTrue((boolean)result);
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_ONE));
    }

    @Test
    default public void replaceAValueByKeyWithLifespanWithOldValue() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        Object result = this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_TWO).withHeader("CamelInfinispanOldValue", (Object)VALUE_ONE).withHeader("CamelInfinispanLifespanTime", (Object)300L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REPLACE).request(Boolean.class);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)result);
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_ONE));
        InfinispanProducerTestSupport.wait(300L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE));
    }

    @Test
    default public void replaceAValueByKeyWithLifespanAndMaxIdleTimeWithOldValue() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        Object result = this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_TWO).withHeader("CamelInfinispanOldValue", (Object)VALUE_ONE).withHeader("CamelInfinispanLifespanTime", (Object)-1L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanMaxIdleTime", (Object)500L).withHeader("CamelInfinispanMaxIdleTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REPLACE).request(Boolean.class);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)result);
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_ONE));
        InfinispanProducerTestSupport.wait(500L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE));
    }

    @Test
    default public void replaceAValueByKeyAsync() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        String result = (String)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_TWO).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REPLACEASYNC).request(String.class);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)result);
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_ONE));
    }

    @Test
    default public void replaceAValueByKeyWithLifespanAsync() throws Exception {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        Object result = ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_TWO).withHeader("CamelInfinispanLifespanTime", (Object)300L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REPLACEASYNC).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)VALUE_ONE, result);
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_ONE));
        InfinispanProducerTestSupport.wait(300L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE));
    }

    @Test
    default public void replaceAValueByKeyWithLifespanAndMaxIdleTimeAsync() throws Exception {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        Object result = ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_TWO).withHeader("CamelInfinispanLifespanTime", (Object)-1L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanMaxIdleTime", (Object)500L).withHeader("CamelInfinispanMaxIdleTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REPLACEASYNC).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)VALUE_ONE, result);
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_ONE));
        InfinispanProducerTestSupport.wait(500L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE));
    }

    @Test
    default public void replaceAValueByKeyAsyncWithOldValue() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        Boolean result = (Boolean)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_TWO).withHeader("CamelInfinispanOldValue", (Object)VALUE_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REPLACEASYNC).request(Boolean.class);
        Assertions.assertTrue((boolean)result);
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_ONE));
    }

    @Test
    default public void replaceAValueByKeyWithLifespanAsyncWithOldValue() throws Exception {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        Object result = ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_TWO).withHeader("CamelInfinispanOldValue", (Object)VALUE_ONE).withHeader("CamelInfinispanLifespanTime", (Object)300L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REPLACEASYNC).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Boolean.TRUE, result);
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_ONE));
        InfinispanProducerTestSupport.wait(500L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE));
    }

    @Test
    default public void replaceAValueByKeyWithLifespanAndMaxIdleTimeAsyncWithOldValue() throws Exception {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        Object result = ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_TWO).withHeader("CamelInfinispanOldValue", (Object)VALUE_ONE).withHeader("CamelInfinispanLifespanTime", (Object)-1L).withHeader("CamelInfinispanTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanMaxIdleTime", (Object)500L).withHeader("CamelInfinispanMaxIdleTimeUnit", (Object)TimeUnit.MILLISECONDS).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REPLACEASYNC).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Boolean.TRUE, result);
        Assertions.assertEquals((Object)VALUE_TWO, (Object)this.getCache().get((Object)KEY_ONE));
        InfinispanProducerTestSupport.wait(500L, 5000L, () -> !this.getCache().containsKey((Object)KEY_ONE));
    }

    @Test
    default public void deletesExistingValueByKey() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        String result = (String)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REMOVE).request(String.class);
        Assertions.assertEquals((Object)VALUE_ONE, (Object)result);
        Assertions.assertNull((Object)this.getCache().get((Object)KEY_ONE));
    }

    @Test
    default public void deletesExistingValueByKeyAsync() throws Exception {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REMOVEASYNC).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertNull((Object)this.getCache().get((Object)KEY_ONE));
    }

    @Test
    default public void deletesExistingValueByKeyWithValue() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        Boolean result = (Boolean)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REMOVE).request(Boolean.class);
        Assertions.assertTrue((boolean)result);
        Assertions.assertNull((Object)this.getCache().get((Object)KEY_ONE));
    }

    @Test
    default public void deletesExistingValueByKeyAsyncWithValue() throws Exception {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REMOVEASYNC).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertNull((Object)this.getCache().get((Object)KEY_ONE));
    }

    @Test
    default public void clearsAllValues() {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.CLEAR).send();
        Assertions.assertTrue((boolean)this.getCache().isEmpty());
    }

    @Test
    default public void testUriCommandOption() {
        this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)COMMAND_KEY).withHeader("CamelInfinispanValue", (Object)COMMAND_VALUE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUT).request(String.class);
        Assertions.assertEquals((Object)COMMAND_VALUE, (Object)this.getCache().get((Object)COMMAND_KEY));
        String result2 = (String)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)COMMAND_KEY).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.GET).request(String.class);
        Assertions.assertEquals((Object)COMMAND_VALUE, (Object)result2);
        String result3 = (String)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanKey", (Object)COMMAND_KEY).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.REMOVE).request(String.class);
        Assertions.assertEquals((Object)COMMAND_VALUE, (Object)result3);
        Assertions.assertNull((Object)this.getCache().get((Object)COMMAND_KEY));
        Assertions.assertTrue((boolean)this.getCache().isEmpty());
        this.getCache().put((Object)COMMAND_KEY, (Object)COMMAND_VALUE);
        this.getCache().put((Object)"keyTest", (Object)"valueTest");
        this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.CLEAR).send();
        Assertions.assertTrue((boolean)this.getCache().isEmpty());
    }

    @Test
    default public void clearAsyncTest() throws Exception {
        this.getCache().put((Object)KEY_ONE, (Object)VALUE_ONE);
        this.getCache().put((Object)KEY_TWO, (Object)VALUE_TWO);
        ((CompletableFuture)this.fluentTemplate().to("direct:start").withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.CLEARASYNC).request(CompletableFuture.class)).get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.getCache().isEmpty());
    }

    @Test
    default public void publishKeyAndValueByExplicitlySpecifyingTheKeyAndValueOptions() {
        this.fluentTemplate().to("direct:explicitput").withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUT).send();
        Assertions.assertEquals((Object)"3", (Object)this.getCache().get((Object)"a"));
    }

    @Test
    default public void publishKeyAndValueByExplicitlySpecifyingTheKeyAndValueOptionsHeaderHavePriorities() {
        this.fluentTemplate().to("direct:explicitput").withHeader("CamelInfinispanKey", (Object)KEY_ONE).withHeader("CamelInfinispanValue", (Object)VALUE_ONE).withHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUT).send();
        Assertions.assertEquals((Object)VALUE_ONE, (Object)this.getCache().get((Object)KEY_ONE));
    }
}

