/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.component.infinispan.InfinispanEventProcessor;

public abstract class InfinispanEventListener<T> {
    private final Set<T> events;
    private InfinispanEventProcessor eventProcessor;
    private String cacheName;

    public InfinispanEventListener(Set<T> events) {
        this.events = Collections.unmodifiableSet(new HashSet<T>(events));
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public InfinispanEventProcessor getEventProcessor() {
        return this.eventProcessor;
    }

    public void setEventProcessor(InfinispanEventProcessor eventProcessor) {
        this.eventProcessor = eventProcessor;
    }

    public Set<T> getEvents() {
        return this.events;
    }

    protected boolean isAccepted(T eventType) {
        return this.events == null || this.events.isEmpty() || this.events.contains(eventType);
    }
}

