/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.server;

import java.net.UnknownHostException;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.iec60870.AbstractIecComponent;
import org.apache.camel.component.iec60870.ConnectionId;
import org.apache.camel.component.iec60870.ObjectAddress;
import org.apache.camel.component.iec60870.server.ServerConnectionMultiplexor;
import org.apache.camel.component.iec60870.server.ServerEndpoint;
import org.apache.camel.component.iec60870.server.ServerInstance;
import org.apache.camel.component.iec60870.server.ServerOptions;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModuleOptions;

@Component(value="iec60870-server")
public class ServerComponent
extends AbstractIecComponent<ServerConnectionMultiplexor, ServerOptions> {
    public ServerComponent(CamelContext context) {
        super(ServerOptions.class, new ServerOptions(), context);
    }

    public ServerComponent() {
        super(ServerOptions.class, new ServerOptions());
    }

    @Override
    protected void applyDataModuleOptions(ServerOptions options, Map<String, Object> parameters) {
        if (parameters.get("dataModuleOptions") instanceof DataModuleOptions) {
            options.setDataModuleOptions((DataModuleOptions)parameters.get("dataModuleOptions"));
        }
    }

    @Override
    protected ServerConnectionMultiplexor createConnection(ConnectionId id, ServerOptions options) {
        try {
            return new ServerConnectionMultiplexor(new ServerInstance(id.getHost(), id.getPort(), options));
        }
        catch (UnknownHostException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    @Override
    protected Endpoint createEndpoint(String uri, ServerConnectionMultiplexor connection, ObjectAddress address) {
        return new ServerEndpoint(uri, (DefaultComponent)this, connection, address);
    }

    @Override
    @Metadata
    public void setDefaultConnectionOptions(ServerOptions defaultConnectionOptions) {
        super.setDefaultConnectionOptions(defaultConnectionOptions);
    }

    @Override
    public ServerOptions getDefaultConnectionOptions() {
        return (ServerOptions)super.getDefaultConnectionOptions();
    }
}

