/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aries.handler;

import io.nessus.aries.util.AssertState;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.aries.HyperledgerAriesEndpoint;
import org.apache.camel.component.aries.UnsupportedServiceException;
import org.apache.camel.component.aries.handler.AbstractServiceHandler;
import org.hyperledger.acy_py.generated.model.ConnectionInvitation;
import org.hyperledger.aries.api.connection.ConnectionAcceptInvitationFilter;
import org.hyperledger.aries.api.connection.ConnectionFilter;
import org.hyperledger.aries.api.connection.ConnectionReceiveInvitationFilter;
import org.hyperledger.aries.api.connection.ConnectionRecord;
import org.hyperledger.aries.api.connection.CreateInvitationRequest;
import org.hyperledger.aries.api.connection.CreateInvitationResponse;
import org.hyperledger.aries.api.connection.ReceiveInvitationRequest;
import org.hyperledger.aries.api.trustping.PingRequest;
import org.hyperledger.aries.api.trustping.PingResponse;

public class ConnectionsServiceHandler
extends AbstractServiceHandler {
    public ConnectionsServiceHandler(HyperledgerAriesEndpoint endpoint) {
        super(endpoint);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(Exchange exchange, String service) throws Exception {
        if (service.equals("/connections")) {
            ConnectionFilter filter = this.maybeHeader(exchange, ConnectionFilter.class);
            List resObj = (List)this.createClient().connections(filter).get();
            exchange.getIn().setBody((Object)resObj);
            return;
        } else if (service.equals("/connections/create-invitation")) {
            CreateInvitationRequest reqObj = this.maybeBody(exchange, CreateInvitationRequest.class);
            if (reqObj == null) {
                reqObj = CreateInvitationRequest.builder().build();
            }
            CreateInvitationResponse resObj = (CreateInvitationResponse)this.createClient().connectionsCreateInvitation(reqObj).get();
            exchange.getIn().setBody((Object)resObj);
            return;
        } else if (service.equals("/connections/receive-invitation")) {
            ReceiveInvitationRequest reqObj = this.maybeBody(exchange, ReceiveInvitationRequest.class);
            if (reqObj == null) {
                ConnectionInvitation invitation = this.assertBody(exchange, ConnectionInvitation.class);
                reqObj = ReceiveInvitationRequest.builder().recipientKeys(invitation.getRecipientKeys()).serviceEndpoint(invitation.getServiceEndpoint()).build();
            }
            ConnectionReceiveInvitationFilter filter = this.maybeHeader(exchange, ConnectionReceiveInvitationFilter.class);
            ConnectionRecord resObj = (ConnectionRecord)this.createClient().connectionsReceiveInvitation(reqObj, filter).get();
            exchange.getIn().setBody((Object)resObj);
            return;
        } else {
            if (!service.startsWith("/connections/")) throw new UnsupportedServiceException(service);
            String connectionId = this.getServicePathToken(service, 1);
            AssertState.notNull((Object)connectionId, (String)"Null connectionId");
            if (service.endsWith("/accept-invitation")) {
                ConnectionAcceptInvitationFilter acceptFilter = this.maybeHeader(exchange, ConnectionAcceptInvitationFilter.class);
                ConnectionRecord resObj = (ConnectionRecord)this.createClient().connectionsAcceptInvitation(connectionId, acceptFilter).get();
                exchange.getIn().setBody((Object)resObj);
                return;
            } else if (service.endsWith("/send-ping")) {
                PingRequest pingRequest = this.assertBody(exchange, PingRequest.class);
                PingResponse resObj = (PingResponse)this.createClient().connectionsSendPing(connectionId, pingRequest).get();
                exchange.getIn().setBody((Object)resObj);
                return;
            } else {
                if (!service.endsWith(connectionId)) throw new UnsupportedServiceException(service);
                ConnectionRecord resObj = this.createClient().connectionsGetById(connectionId).orElse(null);
                exchange.getIn().setBody((Object)resObj);
            }
        }
    }
}

