/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.obs;

import com.obs.services.HttpProxyConfiguration;
import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.huaweicloud.common.models.ServiceKeys;
import org.apache.camel.component.huaweicloud.obs.OBSComponent;
import org.apache.camel.component.huaweicloud.obs.OBSConsumer;
import org.apache.camel.component.huaweicloud.obs.OBSProducer;
import org.apache.camel.component.huaweicloud.obs.constants.OBSHeaders;
import org.apache.camel.component.huaweicloud.obs.models.OBSRegion;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.12.0", scheme="hwcloud-obs", title="Huawei Object Storage Service (OBS)", syntax="hwcloud-obs:operation", category={Category.CLOUD}, headersClass=OBSHeaders.class)
public class OBSEndpoint
extends ScheduledPollEndpoint {
    @UriPath(description="Operation to be performed", displayName="Operation", label="producer")
    @Metadata(required=true)
    private String operation;
    @UriParam(description="OBS service region. This is lower precedence than endpoint based configuration", displayName="Service region")
    @Metadata(required=true)
    private String region;
    @UriParam(description="OBS url. Carries higher precedence than region parameter based client initialization", displayName="Endpoint url")
    @Metadata(required=false)
    private String endpoint;
    @UriParam(description="Proxy server ip/hostname", displayName="Proxy server host", label="proxy")
    @Metadata(required=false)
    private String proxyHost;
    @UriParam(description="Proxy server port", displayName="Proxy server port", label="proxy")
    @Metadata(required=false)
    private int proxyPort;
    @UriParam(description="Proxy authentication user", displayName="Proxy user", secret=true, label="proxy")
    @Metadata(required=false)
    private String proxyUser;
    @UriParam(description="Proxy authentication password", displayName="Proxy password", secret=true, label="proxy")
    @Metadata(required=false)
    private String proxyPassword;
    @UriParam(description="Ignore SSL verification", displayName="SSL Verification Ignored", defaultValue="false", label="security")
    @Metadata(required=false)
    private boolean ignoreSslVerification;
    @UriParam(description="Configuration object for cloud service authentication", displayName="Service Configuration", secret=true, label="security")
    @Metadata(required=false)
    private ServiceKeys serviceKeys;
    @UriParam(description="Access key for the cloud user", displayName="API access key (AK)", secret=true, label="security")
    @Metadata(required=true)
    private String accessKey;
    @UriParam(description="Secret key for the cloud user", displayName="API secret key (SK)", secret=true, label="security")
    @Metadata(required=true)
    private String secretKey;
    @UriParam(description="Name of bucket to perform operation on", displayName="Bucket Name")
    @Metadata(required=false)
    private String bucketName;
    @UriParam(description="Name of object to perform operation with", displayName="Object Name")
    @Metadata(required=false)
    private String objectName;
    @UriParam(description="Location of bucket when creating a new bucket", displayName="Bucket Location", label="producer")
    @Metadata(required=false)
    private String bucketLocation;
    private ObsClient obsClient;
    @UriParam(description="Determines whether objects should be moved to a different bucket after they have been retrieved. The destinationBucket option must also be set for this option to work.", displayName="Move After Read", defaultValue="false", label="consumer")
    @Metadata(required=false)
    private boolean moveAfterRead;
    @UriParam(description="Name of destination bucket where objects will be moved when moveAfterRead is set to true", displayName="Destination Bucket", label="consumer")
    @Metadata(required=false)
    private String destinationBucket;
    @UriParam(description="Get the object from the bucket with the given file name", displayName="File Name", label="consumer")
    @Metadata(required=false)
    private String fileName;
    @UriParam(description="The object name prefix used for filtering objects to be listed", displayName="Prefix", label="consumer")
    @Metadata(required=false)
    private String prefix;
    @UriParam(description="The character used for grouping object names", displayName="Delimiter", label="consumer")
    @Metadata(required=false)
    private String delimiter;
    @UriParam(description="If true, objects in folders will be consumed. Otherwise, they will be ignored and no Exchanges will be created for them", displayName="Include Folders", defaultValue="true", label="consumer")
    @Metadata(required=false)
    private boolean includeFolders = true;
    @UriParam(description="Determines if objects should be deleted after it has been retrieved", displayName="Delete after read", defaultValue="false", label="consumer")
    @Metadata(required=false)
    private boolean deleteAfterRead;
    @UriParam(description="The maximum number of messages to poll at each polling", displayName="Maximum messages per poll", defaultValue="10", label="consumer")
    @Metadata(required=false)
    private int maxMessagesPerPoll = 10;

    public OBSEndpoint() {
    }

    public OBSEndpoint(String uri, String operation, OBSComponent component) {
        super(uri, (Component)component);
        this.operation = operation;
    }

    public Producer createProducer() throws Exception {
        return new OBSProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        OBSConsumer consumer = new OBSConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        consumer.setMaxMessagesPerPoll(this.maxMessagesPerPoll);
        return consumer;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public boolean isIgnoreSslVerification() {
        return this.ignoreSslVerification;
    }

    public void setIgnoreSslVerification(boolean ignoreSslVerification) {
        this.ignoreSslVerification = ignoreSslVerification;
    }

    public ServiceKeys getServiceKeys() {
        return this.serviceKeys;
    }

    public void setServiceKeys(ServiceKeys serviceKeys) {
        this.serviceKeys = serviceKeys;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketLocation() {
        return this.bucketLocation;
    }

    public void setBucketLocation(String bucketLocation) {
        this.bucketLocation = bucketLocation;
    }

    public ObsClient getObsClient() {
        return this.obsClient;
    }

    public void setObsClient(ObsClient obsClient) {
        this.obsClient = obsClient;
    }

    public boolean isMoveAfterRead() {
        return this.moveAfterRead;
    }

    public void setMoveAfterRead(boolean moveAfterRead) {
        this.moveAfterRead = moveAfterRead;
    }

    public String getDestinationBucket() {
        return this.destinationBucket;
    }

    public void setDestinationBucket(String destinationBucket) {
        this.destinationBucket = destinationBucket;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isIncludeFolders() {
        return this.includeFolders;
    }

    public void setIncludeFolders(boolean includeFolders) {
        this.includeFolders = includeFolders;
    }

    public boolean isDeleteAfterRead() {
        return this.deleteAfterRead;
    }

    public void setDeleteAfterRead(boolean deleteAfterRead) {
        this.deleteAfterRead = deleteAfterRead;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public ObsClient initClient() {
        if (this.obsClient != null) {
            return this.obsClient;
        }
        if (ObjectHelper.isEmpty((Object)this.getServiceKeys()) && ObjectHelper.isEmpty((String)this.getAccessKey())) {
            throw new IllegalArgumentException("Authentication parameter 'access key (AK)' not found");
        }
        if (ObjectHelper.isEmpty((Object)this.getServiceKeys()) && ObjectHelper.isEmpty((String)this.getSecretKey())) {
            throw new IllegalArgumentException("Authentication parameter 'secret key (SK)' not found");
        }
        ObsConfiguration obsConfiguration = new ObsConfiguration();
        if (ObjectHelper.isNotEmpty((String)this.getEndpoint())) {
            obsConfiguration.setEndPoint(this.getEndpoint());
        } else if (ObjectHelper.isNotEmpty((String)this.getRegion())) {
            obsConfiguration.setEndPoint(OBSRegion.valueOf(this.getRegion()));
        } else {
            throw new IllegalArgumentException("Region/endpoint not found");
        }
        if (ObjectHelper.isNotEmpty((String)this.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.getProxyPort())) {
            HttpProxyConfiguration httpConfig = new HttpProxyConfiguration();
            httpConfig.setProxyAddr(this.getProxyHost());
            httpConfig.setProxyPort(this.getProxyPort());
            if (ObjectHelper.isNotEmpty((String)this.getProxyUser())) {
                httpConfig.setProxyUName(this.getProxyUser());
                if (ObjectHelper.isNotEmpty((String)this.getProxyPassword())) {
                    httpConfig.setUserPaaswd(this.getProxyPassword());
                }
            }
            obsConfiguration.setHttpProxy(httpConfig);
        }
        obsConfiguration.setValidateCertificate(!this.isIgnoreSslVerification());
        String auth = this.getServiceKeys() != null ? this.getServiceKeys().getAccessKey() : this.getAccessKey();
        String secret = this.getServiceKeys() != null ? this.getServiceKeys().getSecretKey() : this.getSecretKey();
        return new ObsClient(auth, secret, obsConfiguration);
    }
}

