/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.image;

import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.core.utils.StringUtils;
import com.huaweicloud.sdk.image.v2.ImageClient;
import com.huaweicloud.sdk.image.v2.model.CelebrityRecognitionReq;
import com.huaweicloud.sdk.image.v2.model.ImageTaggingReq;
import com.huaweicloud.sdk.image.v2.model.RunCelebrityRecognitionRequest;
import com.huaweicloud.sdk.image.v2.model.RunCelebrityRecognitionResponse;
import com.huaweicloud.sdk.image.v2.model.RunImageTaggingRequest;
import com.huaweicloud.sdk.image.v2.model.RunImageTaggingResponse;
import com.huaweicloud.sdk.image.v2.region.ImageRegion;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.huaweicloud.image.ImageRecognitionEndpoint;
import org.apache.camel.component.huaweicloud.image.models.ClientConfigurations;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageRecognitionProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ImageRecognitionProducer.class);
    private ImageClient imageClient;
    private ImageRecognitionEndpoint endpoint;

    public ImageRecognitionProducer(ImageRecognitionEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    private ClientConfigurations initializeConfigurations(ImageRecognitionEndpoint endpoint) {
        ClientConfigurations clientConfigurations = new ClientConfigurations();
        clientConfigurations.setAccessKey(this.getAccessKey(endpoint));
        clientConfigurations.setSecretKey(this.getSecretKey(endpoint));
        clientConfigurations.setProjectId(this.getProjectId(endpoint));
        clientConfigurations.setEndpoint(this.getEndpoint(endpoint));
        clientConfigurations.setIgnoreSslVerification(endpoint.isIgnoreSslVerification());
        if (clientConfigurations.isIgnoreSslVerification()) {
            LOG.warn("SSL verification is ignored. This is unsafe in production environment");
        }
        if (!StringUtils.isEmpty((CharSequence)endpoint.getProxyHost())) {
            clientConfigurations.setProxyHost(endpoint.getProxyHost());
            clientConfigurations.setProxyPort(endpoint.getProxyPort());
            clientConfigurations.setProxyUser(endpoint.getProxyUser());
            clientConfigurations.setProxyPassword(endpoint.getProxyPassword());
        }
        return clientConfigurations;
    }

    private ImageClient initializeSdkClient(ImageRecognitionEndpoint endpoint, ClientConfigurations clientConfigurations) {
        if (endpoint.getImageClient() != null) {
            LOG.info("Instance of ImageClient was set on the endpoint. Skipping creation of ImageClient from endpoint parameters");
            this.imageClient = endpoint.getImageClient();
            return endpoint.getImageClient();
        }
        HttpConfig httpConfig = HttpConfig.getDefaultHttpConfig().withIgnoreSSLVerification(clientConfigurations.isIgnoreSslVerification());
        if (!StringUtils.isEmpty((CharSequence)clientConfigurations.getProxyHost())) {
            httpConfig.setProxyHost(clientConfigurations.getProxyHost());
            httpConfig.setProxyPort(clientConfigurations.getProxyPort());
            if (!StringUtils.isEmpty((CharSequence)clientConfigurations.getProxyUser())) {
                httpConfig.setProxyUsername(clientConfigurations.getProxyUser());
                httpConfig.setProxyPassword(clientConfigurations.getProxyPassword());
            }
        }
        BasicCredentials credentials = ((BasicCredentials)((BasicCredentials)new BasicCredentials().withAk(clientConfigurations.getAccessKey())).withSk(clientConfigurations.getSecretKey())).withProjectId(clientConfigurations.getProjectId());
        this.imageClient = (ImageClient)ImageClient.newBuilder().withCredential((ICredential)credentials).withHttpConfig(httpConfig).withEndpoint(clientConfigurations.getEndpoint()).build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully initialized Image client");
        }
        return this.imageClient;
    }

    public void process(Exchange exchange) {
        String operation;
        ClientConfigurations clientConfigurations = this.initializeConfigurations(this.endpoint);
        if (this.imageClient == null) {
            this.initializeSdkClient(this.endpoint, clientConfigurations);
        }
        if (StringUtils.isEmpty((CharSequence)(operation = ((ImageRecognitionEndpoint)super.getEndpoint()).getOperation()))) {
            throw new IllegalStateException("operation name cannot be empty");
        }
        switch (operation) {
            case "celebrityRecognition": {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Performing celebrity recognition");
                }
                this.performCelebrityRecognitionOperation(exchange, clientConfigurations);
                break;
            }
            case "tagRecognition": {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Performing tag recognition");
                }
                this.performTagRecognitionOperation(exchange, clientConfigurations);
                break;
            }
            default: {
                throw new UnsupportedOperationException("operation can only be either tagRecognition or celebrityRecognition");
            }
        }
    }

    private void performCelebrityRecognitionOperation(Exchange exchange, ClientConfigurations clientConfigurations) {
        this.updateClientConfigurations(exchange, clientConfigurations);
        CelebrityRecognitionReq reqBody = new CelebrityRecognitionReq().withImage(clientConfigurations.getImageContent()).withUrl(clientConfigurations.getImageUrl()).withThreshold(Float.valueOf(clientConfigurations.getThreshold()));
        RunCelebrityRecognitionResponse response = this.imageClient.runCelebrityRecognition(new RunCelebrityRecognitionRequest().withBody(reqBody));
        exchange.getMessage().setBody((Object)response.getResult());
    }

    private void performTagRecognitionOperation(Exchange exchange, ClientConfigurations clientConfigurations) {
        this.updateClientConfigurations(exchange, clientConfigurations);
        ImageTaggingReq reqBody = new ImageTaggingReq().withImage(clientConfigurations.getImageContent()).withUrl(clientConfigurations.getImageUrl()).withThreshold(Float.valueOf(clientConfigurations.getThreshold())).withLanguage(clientConfigurations.getTagLanguage()).withLimit(Integer.valueOf(clientConfigurations.getTagLimit()));
        RunImageTaggingResponse response = this.imageClient.runImageTagging(new RunImageTaggingRequest().withBody(reqBody));
        exchange.getMessage().setBody((Object)response.getResult());
    }

    private void updateClientConfigurations(Exchange exchange, ClientConfigurations clientConfigurations) {
        boolean isImageContentSet = true;
        boolean isImageUrlSet = true;
        String imageContent = (String)exchange.getProperty("CamelHwCloudImageContent", String.class);
        if (!StringUtils.isEmpty((CharSequence)imageContent)) {
            clientConfigurations.setImageContent(imageContent);
        } else if (!StringUtils.isEmpty((CharSequence)this.endpoint.getImageContent())) {
            clientConfigurations.setImageContent(this.endpoint.getImageContent());
        } else {
            isImageContentSet = false;
        }
        String imageUrl = (String)exchange.getProperty("CamelHwCloudImageUrl", String.class);
        if (!StringUtils.isEmpty((CharSequence)imageUrl)) {
            clientConfigurations.setImageUrl(imageUrl);
        } else if (!StringUtils.isEmpty((CharSequence)this.endpoint.getImageUrl())) {
            clientConfigurations.setImageUrl(this.endpoint.getImageUrl());
        } else {
            isImageUrlSet = false;
        }
        if (!isImageContentSet && !isImageUrlSet) {
            throw new IllegalArgumentException("either image content or image url should be set");
        }
        String tagLanguageProperty = (String)exchange.getProperty("CamelHwCloudImageTagLanguage", String.class);
        clientConfigurations.setTagLanguage(StringUtils.isEmpty((CharSequence)tagLanguageProperty) ? this.endpoint.getTagLanguage() : tagLanguageProperty);
        if (!"zh".equals(clientConfigurations.getTagLanguage()) && !"en".equals(clientConfigurations.getTagLanguage())) {
            throw new IllegalArgumentException("tag language can only be 'zh' or 'en'");
        }
        Integer tagLimitProperty = (Integer)exchange.getProperty("CamelHwCloudImageTagLimit", Integer.class);
        clientConfigurations.setTagLimit(tagLimitProperty == null ? this.endpoint.getTagLimit() : tagLimitProperty.intValue());
        Float thresholdProperty = (Float)exchange.getProperty("CamelHwCloudImageThreshold", Float.class);
        clientConfigurations.setThreshold(thresholdProperty == null ? this.endpoint.getThreshold() : thresholdProperty.floatValue());
        if (clientConfigurations.getThreshold() == -1.0f) {
            clientConfigurations.setThreshold("tagRecognition".equals(this.endpoint.getOperation()) ? 60.0f : 0.48f);
        }
        this.validateThresholdValue(clientConfigurations.getThreshold(), this.endpoint.getOperation());
    }

    private void validateThresholdValue(float threshold, String operation) {
        if ("tagRecognition".equals(operation)) {
            if (threshold < 0.0f || threshold > 100.0f) {
                throw new IllegalArgumentException("tag recognition threshold should be at 0~100");
            }
        } else if (threshold < 0.0f || threshold > 1.0f) {
            throw new IllegalArgumentException("celebrity recognition threshold should be at 0~1");
        }
    }

    private String getAccessKey(ImageRecognitionEndpoint endpoint) {
        if (!StringUtils.isEmpty((CharSequence)endpoint.getAccessKey())) {
            return endpoint.getAccessKey();
        }
        if (endpoint.getServiceKeys() != null && !StringUtils.isEmpty((CharSequence)endpoint.getServiceKeys().getAccessKey())) {
            return endpoint.getServiceKeys().getAccessKey();
        }
        throw new IllegalArgumentException("authentication parameter 'access key (AK)' not found");
    }

    private String getSecretKey(ImageRecognitionEndpoint endpoint) {
        if (!StringUtils.isEmpty((CharSequence)endpoint.getSecretKey())) {
            return endpoint.getSecretKey();
        }
        if (endpoint.getServiceKeys() != null && !StringUtils.isEmpty((CharSequence)endpoint.getServiceKeys().getSecretKey())) {
            return endpoint.getServiceKeys().getSecretKey();
        }
        throw new IllegalArgumentException("authentication parameter 'secret key (SK)' not found");
    }

    private String getProjectId(ImageRecognitionEndpoint endpoint) {
        if (StringUtils.isEmpty((CharSequence)endpoint.getProjectId())) {
            throw new IllegalArgumentException("Project id not found");
        }
        return endpoint.getProjectId();
    }

    private String getEndpoint(ImageRecognitionEndpoint endpoint) {
        if (!StringUtils.isEmpty((CharSequence)endpoint.getEndpoint())) {
            return endpoint.getEndpoint();
        }
        if (StringUtils.isEmpty((CharSequence)endpoint.getRegion())) {
            throw new IllegalArgumentException("either endpoint or region should be set");
        }
        return ImageRegion.valueOf((String)endpoint.getRegion()).getEndpoint();
    }
}

