/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.huaweicloud.dms.constants;

/**
 * Constants for properties set on the exchange object
 */
public final class DMSProperties {
    public static final String OPERATION = "CamelHwCloudDmsOperation";
    public static final String ENGINE = "CamelHwCloudDmsEngine";
    public static final String INSTANCE_ID = "CamelHwCloudDmsInstanceId";
    public static final String NAME = "CamelHwCloudDmsName";
    public static final String ENGINE_VERSION = "CamelHwCloudDmsEngineVersion";
    public static final String SPECIFICATION = "CamelHwCloudDmsSpecification";
    public static final String STORAGE_SPACE = "CamelHwCloudDmsStorageSpace";
    public static final String PARTITION_NUM = "CamelHwCloudDmsPartitionNum";
    public static final String ACCESS_USER = "CamelHwCloudDmsAccessUser";
    public static final String PASSWORD = "CamelHwCloudDmsPassword";
    public static final String VPC_ID = "CamelHwCloudDmsVpcId";
    public static final String SECURITY_GROUP_ID = "CamelHwCloudDmsSecurityGroupId";
    public static final String SUBNET_ID = "CamelHwCloudDmsSubnetId";
    public static final String AVAILABLE_ZONES = "CamelHwCloudDmsAvailableZones";
    public static final String PRODUCT_ID = "CamelHwCloudDmsProductId";
    public static final String KAFKA_MANAGER_USER = "CamelHwCloudDmsKafkaManagerUser";
    public static final String KAFKA_MANAGER_PASSWORD = "CamelHwCloudDmsKafkaManagerPassword";
    public static final String STORAGE_SPEC_CODE = "CamelHwCloudDmsStorageSpecCode";

    public static final String INSTANCE_DELETED = "CamelHwCloudDmsInstanceDeleted";
    public static final String INSTANCE_UPDATED = "CamelHwCloudDmsInstanceUpdated";

    private DMSProperties() {
    }
}
