/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.LineNumberAware;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.http.HttpActivityListener;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConstants;
import org.apache.camel.component.http.HttpPollingConsumer;
import org.apache.camel.component.http.HttpProducer;
import org.apache.camel.component.http.LoggingHttpActivityListener;
import org.apache.camel.component.http.NoopCookieStore;
import org.apache.camel.component.http.PreemptiveAuthExecChainHandler;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.http.base.cookie.CookieHandler;
import org.apache.camel.http.common.HttpCommonComponent;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.3.0", scheme="http,https", title="HTTP,HTTPS", syntax="http://httpUri", producerOnly=true, category={Category.HTTP}, lenientProperties=true, headersClass=HttpConstants.class)
@Metadata(excludeProperties="httpBinding,matchOnUriPrefix,chunked,transferException", annotations={"protocol=http"})
@ManagedResource(description="Managed HttpEndpoint")
public class HttpEndpoint
extends HttpCommonEndpoint
implements LineNumberAware {
    private static final Logger LOG = LoggerFactory.getLogger(HttpEndpoint.class);
    private int lineNumber;
    private String location;
    @UriParam(label="security", description="To configure security using SSLContextParameters. Important: Only one instance of org.apache.camel.util.jsse.SSLContextParameters is supported per HttpComponent. If you need to use 2 or more different instances, you need to define a new HttpComponent per instance you need.")
    protected SSLContextParameters sslContextParameters;
    @UriParam(label="advanced", description="To use a custom HttpContext instance")
    private HttpContext httpContext;
    @UriParam(label="advanced", description="Register a custom configuration strategy for new HttpClient instances created by producers or consumers such as to configure authentication mechanisms etc.")
    private HttpClientConfigurer httpClientConfigurer;
    @UriParam(label="advanced", prefix="httpClient.", multiValue=true, description="To configure the HttpClient using the key/values from the Map.")
    private Map<String, Object> httpClientOptions;
    @UriParam(label="advanced", prefix="httpConnection.", multiValue=true, description="To configure the connection and the socket using the key/values from the Map.")
    private Map<String, Object> httpConnectionOptions;
    @UriParam(label="advanced", description="To use a custom HttpClientConnectionManager to manage connections")
    private HttpClientConnectionManager clientConnectionManager;
    @UriParam(label="advanced", description="Provide access to the http client request parameters used on new RequestConfig instances used by producers or consumers of this endpoint.")
    private HttpClientBuilder clientBuilder;
    @UriParam(label="advanced", description="Sets a custom HttpClient to be used by the producer")
    private HttpClient httpClient;
    @UriParam(label="advanced", defaultValue="false", description="To use System Properties as fallback for configuration for configuring HTTP Client")
    private boolean useSystemProperties;
    @Metadata(label="timeout", defaultValue="3 minutes", description="Returns the connection lease request timeout used when requesting a connection from the connection manager. A timeout value of zero is interpreted as a disabled timeout.", javaType="org.apache.hc.core5.util.Timeout")
    private Timeout connectionRequestTimeout = Timeout.ofMinutes((long)3L);
    @Metadata(label="timeout", defaultValue="3 minutes", description="Determines the timeout until a new connection is fully established. A timeout value of zero is interpreted as an infinite timeout.", javaType="org.apache.hc.core5.util.Timeout")
    private Timeout connectTimeout = Timeout.ofMinutes((long)3L);
    @Metadata(label="timeout", defaultValue="3 minutes", description="Determines the default socket timeout value for blocking I/O operations.", javaType="org.apache.hc.core5.util.Timeout")
    private Timeout soTimeout = Timeout.ofMinutes((long)3L);
    @Metadata(label="timeout", defaultValue="0", description="Determines the timeout until arrival of a response from the opposite endpoint. A timeout value of zero is interpreted as an infinite timeout. Please note that response timeout may be unsupported by HTTP transports with message multiplexing.", javaType="org.apache.hc.core5.util.Timeout")
    private Timeout responseTimeout = Timeout.ofMilliseconds((long)0L);
    @UriParam(label="producer,advanced", description="To use a custom CookieStore. By default the BasicCookieStore is used which is an in-memory only cookie store. Notice if bridgeEndpoint=true then the cookie store is forced to be a noop cookie store as cookie shouldn't be stored as we are just bridging (eg acting as a proxy). If a cookieHandler is set then the cookie store is also forced to be a noop cookie store as cookie handling is then performed by the cookieHandler.")
    private CookieStore cookieStore = new BasicCookieStore();
    @UriParam(label="producer,advanced", defaultValue="true", description="Whether to clear expired cookies before sending the HTTP request. This ensures the cookies store does not keep growing by adding new cookies which is newer removed when they are expired. If the component has disabled cookie management then this option is disabled too.")
    private boolean clearExpiredCookies = true;
    @UriParam(label="producer,security", description="If this option is true, camel-http sends preemptive basic authentication to the server.")
    private boolean authenticationPreemptive;
    @UriParam(label="producer,advanced", description="Whether the HTTP GET should include the message body or not. By default HTTP GET do not include any HTTP body. However in some rare cases users may need to be able to include the message body.")
    private boolean getWithBody;
    @UriParam(label="producer,advanced", description="Whether the HTTP DELETE should include the message body or not. By default HTTP DELETE do not include any HTTP body. However in some rare cases users may need to be able to include the message body.")
    private boolean deleteWithBody;
    @UriParam(label="advanced", defaultValue="200", description="The maximum number of connections.")
    private int maxTotalConnections;
    @UriParam(label="advanced", defaultValue="20", description="The maximum number of connections per route.")
    private int connectionsPerRoute;
    @UriParam(label="security", description="To use a custom X509HostnameVerifier such as DefaultHostnameVerifier or NoopHostnameVerifier")
    private HostnameVerifier x509HostnameVerifier;
    @UriParam(label="producer,advanced", description="To use custom host header for producer. When not set in query will be ignored. When set will override host header derived from url.")
    private String customHostHeader;
    @UriParam(label="producer", description="Whether to skip mapping all the Camel headers as HTTP request headers. If there are no data from Camel headers needed to be included in the HTTP request then this can avoid parsing overhead with many object allocations for the JVM garbage collector.")
    private boolean skipRequestHeaders;
    @UriParam(label="producer", description="Whether to skip mapping all the HTTP response headers to Camel headers. If there are no data needed from HTTP headers then this can avoid parsing overhead with many object allocations for the JVM garbage collector.")
    private boolean skipResponseHeaders;
    @UriParam(label="producer,advanced", defaultValue="false", description="Whether to the HTTP request should follow redirects. By default the HTTP request does not follow redirects ")
    private boolean followRedirects;
    @UriParam(label="producer,advanced", description="To set a custom HTTP User-Agent request header")
    private String userAgent;
    @UriParam(label="producer,advanced", description="To use a custom activity listener")
    private HttpActivityListener httpActivityListener;
    @UriParam(label="producer", description="To enable logging HTTP request and response. You can use a custom LoggingHttpActivityListener as httpActivityListener to control logging options.")
    private boolean logHttpActivity;

    public HttpEndpoint() {
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI) {
        this(endPointURI, component, httpURI, null);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI, HttpClientConnectionManager clientConnectionManager) {
        this(endPointURI, component, httpURI, HttpClientBuilder.create(), clientConnectionManager, null);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, HttpClientBuilder clientBuilder, HttpClientConnectionManager clientConnectionManager, HttpClientConfigurer clientConfigurer) {
        this(endPointURI, component, null, clientBuilder, clientConnectionManager, clientConfigurer);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI, HttpClientBuilder clientBuilder, HttpClientConnectionManager clientConnectionManager, HttpClientConfigurer clientConfigurer) {
        super(endPointURI, (HttpCommonComponent)component, httpURI);
        this.clientBuilder = clientBuilder;
        this.httpClientConfigurer = clientConfigurer;
        this.clientConnectionManager = clientConnectionManager;
    }

    public Producer createProducer() throws Exception {
        return new HttpProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from http endpoint");
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        HttpPollingConsumer answer = new HttpPollingConsumer(this);
        this.configurePollingConsumer((PollingConsumer)answer);
        return answer;
    }

    public HttpClient getHttpClient() {
        this.lock.lock();
        try {
            if (this.httpClient == null) {
                this.httpClient = this.createHttpClient();
            }
            HttpClient httpClient = this.httpClient;
            return httpClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setHttpClient(HttpClient httpClient) {
        this.lock.lock();
        try {
            this.httpClient = httpClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected HttpClient createHttpClient() {
        HttpClientConfigurer configurer;
        String userAgent;
        ObjectHelper.notNull((Object)this.clientBuilder, (String)"httpClientBuilder");
        ObjectHelper.notNull((Object)this.clientConnectionManager, (String)"httpConnectionManager");
        this.clientBuilder.setDefaultCookieStore(this.cookieStore);
        this.clientBuilder.setConnectionManager(this.clientConnectionManager);
        if (this.getComponent() != null && this.getComponent().getClientConnectionManager() == this.getClientConnectionManager()) {
            this.clientBuilder.setConnectionManagerShared(true);
        }
        if (!this.useSystemProperties) {
            if (ObjectHelper.isNotEmpty((String)this.getCamelContext().getGlobalOption("http.proxyHost")) && ObjectHelper.isNotEmpty((String)this.getCamelContext().getGlobalOption("http.proxyPort"))) {
                String host = this.getCamelContext().getGlobalOption("http.proxyHost");
                int port = Integer.parseInt(this.getCamelContext().getGlobalOption("http.proxyPort"));
                String scheme = this.getCamelContext().getGlobalOption("http.proxyScheme");
                if (scheme == null) {
                    scheme = HttpHelper.isSecureConnection((String)this.getEndpointUri()) ? "https" : "http";
                }
                LOG.debug("CamelContext properties http.proxyHost, http.proxyPort, and http.proxyScheme detected. Using http proxy host: {} port: {} scheme: {}", new Object[]{host, port, scheme});
                HttpHost proxy = new HttpHost(scheme, host, port);
                this.clientBuilder.setProxy(proxy);
            }
        } else {
            this.clientBuilder.useSystemProperties();
        }
        if (this.isAuthenticationPreemptive()) {
            this.clientBuilder.addExecInterceptorFirst("preemptive-auth", (ExecChainHandler)new PreemptiveAuthExecChainHandler(this));
        }
        if ((userAgent = this.getUserAgent()) != null) {
            this.clientBuilder.setUserAgent(userAgent);
        }
        if (this.isBridgeEndpoint()) {
            this.clientBuilder.setDefaultCookieStore((CookieStore)new NoopCookieStore());
        }
        if (this.isFollowRedirects()) {
            this.clientBuilder.setRedirectStrategy((RedirectStrategy)DefaultRedirectStrategy.INSTANCE);
        }
        if ((configurer = this.getHttpClientConfigurer()) != null) {
            configurer.configureHttpClient(this.clientBuilder);
        }
        if (this.httpActivityListener != null) {
            this.clientBuilder.addRequestInterceptorLast(new HttpRequestInterceptor(){

                public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
                    Exchange exchange = (Exchange)context.getAttribute("org.apache.camel.Exchange");
                    HttpHost host = (HttpHost)context.getAttribute("org.apache.hc.core5.http.HttpHost");
                    context.setAttribute("org.apache.camel.util.StopWatch", (Object)new StopWatch());
                    HttpEndpoint.this.httpActivityListener.onRequestSubmitted(this, exchange, host, request, (HttpEntity)entity);
                }
            });
            this.clientBuilder.addResponseInterceptorFirst(new HttpResponseInterceptor(){

                public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
                    long elapsed = -1L;
                    StopWatch watch = (StopWatch)context.removeAttribute("org.apache.camel.util.StopWatch");
                    if (watch != null) {
                        elapsed = watch.taken();
                    }
                    Exchange exchange = (Exchange)context.removeAttribute("org.apache.camel.Exchange");
                    HttpHost host = (HttpHost)context.removeAttribute("org.apache.hc.core5.http.HttpHost");
                    HttpEndpoint.this.httpActivityListener.onResponseReceived(this, exchange, host, response, (HttpEntity)entity, elapsed);
                }
            });
        }
        LOG.debug("Setup the HttpClientBuilder {}", (Object)this.clientBuilder);
        return this.clientBuilder.build();
    }

    public HttpComponent getComponent() {
        return (HttpComponent)super.getComponent();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.logHttpActivity && this.httpActivityListener == null) {
            this.httpActivityListener = new LoggingHttpActivityListener();
        }
        CamelContextAware.trySetCamelContext((Object)this.httpActivityListener, (CamelContext)this.getCamelContext());
        ServiceHelper.startService((Object)this.httpActivityListener);
    }

    protected void doStop() throws Exception {
        HttpClient httpClient;
        if (this.getComponent() != null && this.getComponent().getClientConnectionManager() != this.clientConnectionManager) {
            this.clientConnectionManager.close();
        }
        if ((httpClient = this.httpClient) instanceof Closeable) {
            Closeable closeable = (Closeable)httpClient;
            IOHelper.close((Closeable)closeable);
        }
        ServiceHelper.stopService((Object)this.httpActivityListener);
        super.doStop();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public HttpClientBuilder getClientBuilder() {
        return this.clientBuilder;
    }

    public void setClientBuilder(HttpClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public HttpClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public void setClientConnectionManager(HttpClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    public boolean isClearExpiredCookies() {
        return this.clearExpiredCookies;
    }

    public void setClearExpiredCookies(boolean clearExpiredCookies) {
        this.clearExpiredCookies = clearExpiredCookies;
    }

    public boolean isDeleteWithBody() {
        return this.deleteWithBody;
    }

    public void setDeleteWithBody(boolean deleteWithBody) {
        this.deleteWithBody = deleteWithBody;
    }

    public boolean isGetWithBody() {
        return this.getWithBody;
    }

    public void setGetWithBody(boolean getWithBody) {
        this.getWithBody = getWithBody;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void setCookieHandler(CookieHandler cookieHandler) {
        super.setCookieHandler(cookieHandler);
        this.cookieStore = new NoopCookieStore();
    }

    public boolean isAuthenticationPreemptive() {
        return this.authenticationPreemptive;
    }

    public void setAuthenticationPreemptive(boolean authenticationPreemptive) {
        this.authenticationPreemptive = authenticationPreemptive;
    }

    public Map<String, Object> getHttpClientOptions() {
        return this.httpClientOptions;
    }

    public void setHttpClientOptions(Map<String, Object> httpClientOptions) {
        this.httpClientOptions = httpClientOptions;
    }

    public Map<String, Object> getHttpConnectionOptions() {
        return this.httpConnectionOptions;
    }

    public void setHttpConnectionOptions(Map<String, Object> httpConnectionOptions) {
        this.httpConnectionOptions = httpConnectionOptions;
    }

    public boolean isUseSystemProperties() {
        return this.useSystemProperties;
    }

    public void setUseSystemProperties(boolean useSystemProperties) {
        this.useSystemProperties = useSystemProperties;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getConnectionsPerRoute() {
        return this.connectionsPerRoute;
    }

    public void setConnectionsPerRoute(int connectionsPerRoute) {
        this.connectionsPerRoute = connectionsPerRoute;
    }

    public HostnameVerifier getX509HostnameVerifier() {
        return this.x509HostnameVerifier;
    }

    public void setX509HostnameVerifier(HostnameVerifier x509HostnameVerifier) {
        this.x509HostnameVerifier = x509HostnameVerifier;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public Timeout getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(Timeout connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public Timeout getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Timeout connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Timeout getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(Timeout soTimeout) {
        this.soTimeout = soTimeout;
    }

    public Timeout getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(Timeout responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setCustomHostHeader(String customHostHeader) {
        this.customHostHeader = customHostHeader;
    }

    public String getCustomHostHeader() {
        return this.customHostHeader;
    }

    public boolean isSkipRequestHeaders() {
        return this.skipRequestHeaders;
    }

    public void setSkipRequestHeaders(boolean skipRequestHeaders) {
        this.skipRequestHeaders = skipRequestHeaders;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public boolean isSkipResponseHeaders() {
        return this.skipResponseHeaders;
    }

    public void setSkipResponseHeaders(boolean skipResponseHeaders) {
        this.skipResponseHeaders = skipResponseHeaders;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public HttpActivityListener getHttpActivityListener() {
        return this.httpActivityListener;
    }

    public void setHttpActivityListener(HttpActivityListener httpActivityListener) {
        this.httpActivityListener = httpActivityListener;
    }

    public boolean isLogHttpActivity() {
        return this.logHttpActivity;
    }

    public void setLogHttpActivity(boolean logHttpActivity) {
        this.logHttpActivity = logHttpActivity;
    }

    @ManagedAttribute(description="Maximum number of allowed persistent connections")
    public int getClientConnectionsPoolStatsMax() {
        PoolStats stats;
        ConnPoolControl pool = null;
        HttpClientConnectionManager httpClientConnectionManager = this.clientConnectionManager;
        if (httpClientConnectionManager instanceof ConnPoolControl) {
            ConnPoolControl connPoolControl;
            pool = connPoolControl = (ConnPoolControl)httpClientConnectionManager;
        }
        if (pool != null && (stats = pool.getTotalStats()) != null) {
            return stats.getMax();
        }
        return -1;
    }

    @ManagedAttribute(description="Number of available idle persistent connections")
    public int getClientConnectionsPoolStatsAvailable() {
        PoolStats stats;
        ConnPoolControl pool = null;
        HttpClientConnectionManager httpClientConnectionManager = this.clientConnectionManager;
        if (httpClientConnectionManager instanceof ConnPoolControl) {
            ConnPoolControl connPoolControl;
            pool = connPoolControl = (ConnPoolControl)httpClientConnectionManager;
        }
        if (pool != null && (stats = pool.getTotalStats()) != null) {
            return stats.getAvailable();
        }
        return -1;
    }

    @ManagedAttribute(description="Number of persistent connections tracked by the connection manager currently being used to execute requests")
    public int getClientConnectionsPoolStatsLeased() {
        PoolStats stats;
        ConnPoolControl pool = null;
        HttpClientConnectionManager httpClientConnectionManager = this.clientConnectionManager;
        if (httpClientConnectionManager instanceof ConnPoolControl) {
            ConnPoolControl connPoolControl;
            pool = connPoolControl = (ConnPoolControl)httpClientConnectionManager;
        }
        if (pool != null && (stats = pool.getTotalStats()) != null) {
            return stats.getLeased();
        }
        return -1;
    }

    @ManagedAttribute(description="Number of connection requests being blocked awaiting a free connection. This can happen only if there are more worker threads contending for fewer connections.")
    public int getClientConnectionsPoolStatsPending() {
        PoolStats stats;
        ConnPoolControl pool = null;
        HttpClientConnectionManager httpClientConnectionManager = this.clientConnectionManager;
        if (httpClientConnectionManager instanceof ConnPoolControl) {
            ConnPoolControl connPoolControl;
            pool = connPoolControl = (ConnPoolControl)httpClientConnectionManager;
        }
        if (pool != null && (stats = pool.getTotalStats()) != null) {
            return stats.getPending();
        }
        return -1;
    }
}

