/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.util.Optional;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.ProxyHost;

public class HttpProxyConfigurer
implements HttpClientConfigurer {
    private final Optional<String> proxyHost;
    private final Optional<Integer> proxyPort;

    public HttpProxyConfigurer(Optional<String> proxyHost) {
        this(proxyHost, Optional.empty());
    }

    public HttpProxyConfigurer(Optional<String> proxyHost, Optional<Integer> proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    @Override
    public void configureHttpClient(HttpClient client) {
        if (this.proxyHost.isPresent() && this.proxyPort.isPresent()) {
            client.getHostConfiguration().setProxyHost(new ProxyHost(this.proxyHost.get(), this.proxyPort.get().intValue()));
        }
        if (this.proxyHost.isPresent()) {
            client.getHostConfiguration().setProxyHost(new ProxyHost(this.proxyHost.get()));
        }
    }
}

