/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs2;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.login.Configuration;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.hdfs2.HdfsComponent;
import org.apache.camel.component.hdfs2.HdfsConfiguration;
import org.apache.camel.component.hdfs2.HdfsEndpoint;
import org.apache.camel.component.hdfs2.HdfsFileType;
import org.apache.camel.component.hdfs2.HdfsHeader;
import org.apache.camel.component.hdfs2.HdfsInfo;
import org.apache.camel.component.hdfs2.HdfsInfoFactory;
import org.apache.camel.component.hdfs2.HdfsInputStream;
import org.apache.camel.component.hdfs2.Holder;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.util.IOHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;

public final class HdfsConsumer
extends ScheduledPollConsumer {
    private final HdfsConfiguration config;
    private final StringBuilder hdfsPath;
    private final Processor processor;
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    private volatile HdfsInputStream istream;

    public HdfsConsumer(HdfsEndpoint endpoint, Processor processor, HdfsConfiguration config) {
        super((Endpoint)endpoint, processor);
        this.config = config;
        this.hdfsPath = config.getFileSystemType().getHdfsPath(config);
        this.processor = processor;
        this.setInitialDelay(config.getInitialDelay());
        this.setDelay(config.getDelay());
        this.setUseFixedDelay(true);
    }

    public HdfsEndpoint getEndpoint() {
        return (HdfsEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.config.isConnectOnStartup()) {
            this.setupHdfs(true);
        }
    }

    private HdfsInfo setupHdfs(boolean onStartup) throws Exception {
        if (onStartup) {
            this.log.info("Connecting to hdfs file-system {}:{}/{} (may take a while if connection is not available)", new Object[]{this.config.getHostName(), this.config.getPort(), this.hdfsPath.toString()});
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Connecting to hdfs file-system {}:{}/{} (may take a while if connection is not available)", new Object[]{this.config.getHostName(), this.config.getPort(), this.hdfsPath.toString()});
        }
        HdfsInfo answer = HdfsInfoFactory.newHdfsInfo(this.hdfsPath.toString());
        if (onStartup) {
            this.log.info("Connected to hdfs file-system {}:{}/{}", new Object[]{this.config.getHostName(), this.config.getPort(), this.hdfsPath.toString()});
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Connected to hdfs file-system {}:{}/{}", new Object[]{this.config.getHostName(), this.config.getPort(), this.hdfsPath.toString()});
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        Configuration auth = HdfsComponent.getJAASConfiguration();
        try {
            int n = this.doPoll();
            return n;
        }
        finally {
            HdfsComponent.setJAASConfiguration(auth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doPoll() throws Exception {
        FileStatus[] fileStatuses;
        int numMessages = 0;
        HdfsInfo info = this.setupHdfs(false);
        if (info.getFileSystem().isFile(info.getPath())) {
            fileStatuses = info.getFileSystem().globStatus(info.getPath());
        } else {
            Path pattern = info.getPath().suffix("/" + this.config.getPattern());
            class ExcludePathFilter
            implements PathFilter {
                ExcludePathFilter() {
                }

                public boolean accept(Path path) {
                    return !path.toString().endsWith(HdfsConsumer.this.config.getOpenedSuffix()) && !path.toString().endsWith(HdfsConsumer.this.config.getReadSuffix());
                }
            }
            fileStatuses = info.getFileSystem().globStatus(pattern, (PathFilter)new ExcludePathFilter());
        }
        for (FileStatus status : fileStatuses) {
            if (this.normalFileIsDirectoryNoSuccessFile(status, info)) continue;
            if (this.config.getOwner() != null && !this.config.getOwner().equals(status.getOwner())) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Skipping file: {} as not matching owner: {}", (Object)status.getPath().toString(), (Object)this.config.getOwner());
                continue;
            }
            try {
                this.rwlock.writeLock().lock();
                this.istream = HdfsInputStream.createInputStream(status.getPath().toString(), this.config);
            }
            finally {
                this.rwlock.writeLock().unlock();
            }
            try {
                Holder<Object> key = new Holder<Object>();
                Holder<Object> value = new Holder<Object>();
                while (this.istream.next(key, value) != 0L) {
                    Exchange exchange = this.getEndpoint().createExchange();
                    DefaultMessage message = new DefaultMessage();
                    String fileName = StringUtils.substringAfterLast((String)status.getPath().toString(), (String)"/");
                    message.setHeader("CamelFileName", (Object)fileName);
                    if (key.value != null) {
                        message.setHeader(HdfsHeader.KEY.name(), key.value);
                    }
                    message.setBody(value.value);
                    exchange.setIn((Message)message);
                    this.log.debug("Processing file {}", (Object)fileName);
                    try {
                        this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        exchange.setException((Throwable)e);
                    }
                    if (exchange.getException() != null) {
                        this.getExceptionHandler().handleException((Throwable)exchange.getException());
                    }
                    ++numMessages;
                }
            }
            finally {
                IOHelper.close((Closeable)this.istream, (String)"input stream", (Logger)this.log);
            }
        }
        return numMessages;
    }

    private boolean normalFileIsDirectoryNoSuccessFile(FileStatus status, HdfsInfo info) throws IOException {
        if (this.config.getFileType().equals((Object)HdfsFileType.NORMAL_FILE) && status.isDirectory()) {
            Path successPath = new Path(status.getPath().toString() + "/_SUCCESS");
            if (!info.getFileSystem().exists(successPath)) {
                return true;
            }
        }
        return false;
    }
}

