/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.hdfs.DefaultHdfsFile;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsHelper;
import org.apache.camel.component.hdfs.HdfsInfo;
import org.apache.camel.component.hdfs.HdfsInfoFactory;
import org.apache.camel.component.hdfs.HdfsInputStream;
import org.apache.camel.component.hdfs.HdfsOutputStream;
import org.apache.camel.component.hdfs.Holder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.util.ReflectionUtils;

class HdfsMapFileHandler
extends DefaultHdfsFile<MapFile.Writer, MapFile.Reader> {
    HdfsMapFileHandler() {
    }

    @Override
    public MapFile.Writer createOutputStream(String hdfsPath, HdfsInfoFactory hdfsInfoFactory) {
        try {
            HdfsInfo hdfsInfo = hdfsInfoFactory.newHdfsInfo(hdfsPath);
            HdfsConfiguration endpointConfig = hdfsInfoFactory.getEndpointConfig();
            Class<? extends WritableComparable> keyWritableClass = endpointConfig.getKeyType().getWritableClass();
            Class<? extends WritableComparable> valueWritableClass = endpointConfig.getValueType().getWritableClass();
            MapFile.Writer rout = new MapFile.Writer(hdfsInfo.getConfiguration(), new Path(hdfsPath), new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(keyWritableClass), MapFile.Writer.valueClass(valueWritableClass), MapFile.Writer.compression((SequenceFile.CompressionType)HdfsHelper.asCompressionType(endpointConfig.getCompressionType()), (CompressionCodec)endpointConfig.getCompressionCodec().getCodec()), MapFile.Writer.progressable(() -> {})});
            return rout;
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public long append(HdfsOutputStream hdfsOutputStream, Object key, Object value, Exchange exchange) {
        try {
            Holder<Integer> keySize = new Holder<Integer>();
            Writable keyWritable = this.getWritable(key, exchange, keySize);
            Holder<Integer> valueSize = new Holder<Integer>();
            Writable valueWritable = this.getWritable(value, exchange, valueSize);
            ((MapFile.Writer)hdfsOutputStream.getOut()).append((WritableComparable)keyWritable, valueWritable);
            return Long.sum(keySize.getValue().intValue(), valueSize.getValue().intValue());
        }
        catch (Exception ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public MapFile.Reader createInputStream(String hdfsPath, HdfsInfoFactory hdfsInfoFactory) {
        try {
            HdfsInfo hdfsInfo = hdfsInfoFactory.newHdfsInfo(hdfsPath);
            MapFile.Reader rin = new MapFile.Reader(new Path(hdfsPath), hdfsInfo.getConfiguration(), new SequenceFile.Reader.Option[0]);
            return rin;
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public long next(HdfsInputStream hdfsInputStream, Holder<Object> key, Holder<Object> value) {
        try {
            MapFile.Reader reader = (MapFile.Reader)hdfsInputStream.getIn();
            Holder<Integer> keySize = new Holder<Integer>();
            WritableComparable keyWritable = (WritableComparable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)new Configuration());
            Holder<Integer> valueSize = new Holder<Integer>();
            Writable valueWritable = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)new Configuration());
            if (reader.next(keyWritable, valueWritable)) {
                key.setValue(this.getObject((Writable)keyWritable, keySize));
                value.setValue(this.getObject(valueWritable, valueSize));
                return Long.sum(keySize.getValue().intValue(), valueSize.getValue().intValue());
            }
            return 0L;
        }
        catch (Exception ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }
}

