/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.component.hdfs.HdfsCompressionCodec;
import org.apache.camel.component.hdfs.HdfsCompressionType;
import org.apache.camel.component.hdfs.HdfsConstants;
import org.apache.camel.component.hdfs.HdfsFileSystemType;
import org.apache.camel.component.hdfs.HdfsFileType;
import org.apache.camel.component.hdfs.HdfsProducer;
import org.apache.camel.component.hdfs.WritableType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

@UriParams
public class HdfsConfiguration {
    private URI uri;
    private boolean wantAppend;
    private List<HdfsProducer.SplitStrategy> splitStrategies;
    @UriPath
    @Metadata(required=true)
    private String hostName;
    @UriPath(defaultValue="8020")
    private int port = 8020;
    @UriPath
    @Metadata(required=true)
    private String path;
    @UriParam(label="producer", defaultValue="true")
    private boolean overwrite = true;
    @UriParam(label="producer")
    private boolean append;
    @UriParam(label="advanced")
    private String splitStrategy;
    @UriParam(label="advanced", defaultValue="4096")
    private int bufferSize = 4096;
    @UriParam(label="advanced", defaultValue="3")
    private short replication = (short)3;
    @UriParam(label="advanced", defaultValue="67108864")
    private long blockSize = 0x4000000L;
    @UriParam(label="advanced", defaultValue="NONE")
    private HdfsCompressionType compressionType = HdfsConstants.DEFAULT_COMPRESSIONTYPE;
    @UriParam(label="advanced", defaultValue="DEFAULT")
    private HdfsCompressionCodec compressionCodec = HdfsConstants.DEFAULT_CODEC;
    @UriParam(defaultValue="NORMAL_FILE")
    private HdfsFileType fileType = HdfsFileType.NORMAL_FILE;
    @UriParam(defaultValue="HDFS")
    private HdfsFileSystemType fileSystemType = HdfsFileSystemType.HDFS;
    @UriParam(defaultValue="NULL")
    private WritableType keyType = WritableType.NULL;
    @UriParam(defaultValue="BYTES")
    private WritableType valueType = WritableType.BYTES;
    @UriParam(label="advanced", defaultValue="opened")
    private String openedSuffix = "opened";
    @UriParam(label="advanced", defaultValue="read")
    private String readSuffix = "read";
    @UriParam(label="consumer", defaultValue="*")
    private String pattern = "*";
    @UriParam(label="advanced", defaultValue="4096")
    private int chunkSize = 4096;
    @UriParam(label="advanced", defaultValue="500")
    private int checkIdleInterval = 500;
    @UriParam(defaultValue="true")
    private boolean connectOnStartup = true;
    @UriParam(label="consumer,filter", defaultValue="100")
    private int maxMessagesPerPoll = 100;
    @UriParam
    private String owner;
    @UriParam(label="consumer", defaultValue="false")
    private boolean streamDownload;
    @UriParam
    private String namedNodes;
    private List<String> namedNodeList = Collections.emptyList();
    @UriParam(label="security")
    private String kerberosConfigFileLocation;
    @UriParam(label="security")
    private String kerberosUsername;
    @UriParam(label="security")
    private String kerberosKeytabLocation;

    private Boolean getBoolean(Map<String, Object> hdfsSettings, String param, Boolean dflt) {
        if (hdfsSettings.containsKey(param)) {
            return Boolean.valueOf((String)hdfsSettings.get(param));
        }
        return dflt;
    }

    private Integer getInteger(Map<String, Object> hdfsSettings, String param, Integer dflt) {
        if (hdfsSettings.containsKey(param)) {
            return Integer.valueOf((String)hdfsSettings.get(param));
        }
        return dflt;
    }

    private Short getShort(Map<String, Object> hdfsSettings, String param, Short dflt) {
        if (hdfsSettings.containsKey(param)) {
            return Short.valueOf((String)hdfsSettings.get(param));
        }
        return dflt;
    }

    private Long getLong(Map<String, Object> hdfsSettings, String param, Long dflt) {
        if (hdfsSettings.containsKey(param)) {
            return Long.valueOf((String)hdfsSettings.get(param));
        }
        return dflt;
    }

    private HdfsFileType getFileType(Map<String, Object> hdfsSettings, String param, HdfsFileType dflt) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return HdfsFileType.valueOf(eit);
        }
        return dflt;
    }

    private HdfsFileSystemType getFileSystemType(Map<String, Object> hdfsSettings, String param, HdfsFileSystemType dflt) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return HdfsFileSystemType.valueOf(eit);
        }
        return dflt;
    }

    private WritableType getWritableType(Map<String, Object> hdfsSettings, String param, WritableType dflt) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return WritableType.valueOf(eit);
        }
        return dflt;
    }

    private HdfsCompressionType getCompressionType(Map<String, Object> hdfsSettings, String param, HdfsCompressionType ct) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return HdfsCompressionType.valueOf(eit);
        }
        return ct;
    }

    private HdfsCompressionCodec getCompressionCodec(Map<String, Object> hdfsSettings, String param, HdfsCompressionCodec cd) {
        String eit = (String)hdfsSettings.get(param);
        if (eit != null) {
            return HdfsCompressionCodec.valueOf(eit);
        }
        return cd;
    }

    private String getString(Map<String, Object> hdfsSettings, String param, String dflt) {
        if (hdfsSettings.containsKey(param)) {
            return (String)hdfsSettings.get(param);
        }
        return dflt;
    }

    private List<HdfsProducer.SplitStrategy> getSplitStrategies(Map<String, Object> hdfsSettings) {
        ArrayList<HdfsProducer.SplitStrategy> strategies = new ArrayList<HdfsProducer.SplitStrategy>();
        this.splitStrategy = this.getString(hdfsSettings, "splitStrategy", this.splitStrategy);
        if (ObjectHelper.isNotEmpty((String)this.splitStrategy)) {
            String[] strategyElements;
            for (String strategyElement : strategyElements = this.splitStrategy.split(",")) {
                String[] tokens = strategyElement.split(":");
                if (tokens.length != 2) {
                    throw new IllegalArgumentException("Wrong Split Strategy [splitStrategy=" + this.splitStrategy + "]");
                }
                HdfsProducer.SplitStrategyType strategyType = HdfsProducer.SplitStrategyType.valueOf(tokens[0]);
                long strategyValue = Long.parseLong(tokens[1]);
                strategies.add(new HdfsProducer.SplitStrategy(strategyType, strategyValue));
            }
        }
        return strategies;
    }

    private List<String> getNamedNodeList(Map<String, Object> hdfsSettings) {
        this.namedNodes = this.getString(hdfsSettings, "namedNodes", this.namedNodes);
        if (ObjectHelper.isNotEmpty((String)this.namedNodes)) {
            return Arrays.stream(this.namedNodes.split(",")).distinct().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void checkConsumerOptions() {
    }

    public void checkProducerOptions() {
        if (this.isAppend()) {
            if (this.hasSplitStrategies()) {
                throw new IllegalArgumentException("Split Strategies incompatible with append=true");
            }
            if (this.getFileType() != HdfsFileType.NORMAL_FILE) {
                throw new IllegalArgumentException("append=true works only with NORMAL_FILEs");
            }
        }
    }

    public void parseURI(URI uri) throws URISyntaxException {
        String protocol = uri.getScheme();
        if (!protocol.equalsIgnoreCase("hdfs")) {
            throw new IllegalArgumentException("Unrecognized protocol: " + protocol + " for uri: " + uri);
        }
        this.hostName = uri.getHost();
        if (this.hostName == null) {
            this.hostName = "localhost";
        }
        this.port = uri.getPort() == -1 ? 8020 : uri.getPort();
        this.path = uri.getPath();
        Map hdfsSettings = URISupport.parseParameters((URI)uri);
        this.overwrite = this.getBoolean(hdfsSettings, "overwrite", this.overwrite);
        this.wantAppend = this.append = this.getBoolean(hdfsSettings, "append", this.append).booleanValue();
        this.bufferSize = this.getInteger(hdfsSettings, "bufferSize", this.bufferSize);
        this.replication = this.getShort(hdfsSettings, "replication", this.replication);
        this.blockSize = this.getLong(hdfsSettings, "blockSize", this.blockSize);
        this.compressionType = this.getCompressionType(hdfsSettings, "compressionType", this.compressionType);
        this.compressionCodec = this.getCompressionCodec(hdfsSettings, "compressionCodec", this.compressionCodec);
        this.fileType = this.getFileType(hdfsSettings, "fileType", this.fileType);
        this.fileSystemType = this.getFileSystemType(hdfsSettings, "fileSystemType", this.fileSystemType);
        this.keyType = this.getWritableType(hdfsSettings, "keyType", this.keyType);
        this.valueType = this.getWritableType(hdfsSettings, "valueType", this.valueType);
        this.openedSuffix = this.getString(hdfsSettings, "openedSuffix", this.openedSuffix);
        this.readSuffix = this.getString(hdfsSettings, "readSuffix", this.readSuffix);
        this.pattern = this.getString(hdfsSettings, "pattern", this.pattern);
        this.chunkSize = this.getInteger(hdfsSettings, "chunkSize", this.chunkSize);
        this.splitStrategies = this.getSplitStrategies(hdfsSettings);
        this.namedNodeList = this.getNamedNodeList(hdfsSettings);
        this.kerberosConfigFileLocation = this.getString(hdfsSettings, "kerberosConfigFileLocation", this.kerberosConfigFileLocation);
        this.kerberosUsername = this.getString(hdfsSettings, "kerberosUsername", this.kerberosUsername);
        this.kerberosKeytabLocation = this.getString(hdfsSettings, "kerberosKeytabLocation", this.kerberosKeytabLocation);
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isAppend() {
        return this.append;
    }

    public boolean isWantAppend() {
        return this.wantAppend;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public short getReplication() {
        return this.replication;
    }

    public void setReplication(short replication) {
        this.replication = replication;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public HdfsFileType getFileType() {
        return this.fileType;
    }

    public void setFileType(HdfsFileType fileType) {
        this.fileType = fileType;
    }

    public HdfsCompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(HdfsCompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public HdfsCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    public void setCompressionCodec(HdfsCompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
    }

    public void setFileSystemType(HdfsFileSystemType fileSystemType) {
        this.fileSystemType = fileSystemType;
    }

    public HdfsFileSystemType getFileSystemType() {
        return this.fileSystemType;
    }

    public WritableType getKeyType() {
        return this.keyType;
    }

    public void setKeyType(WritableType keyType) {
        this.keyType = keyType;
    }

    public WritableType getValueType() {
        return this.valueType;
    }

    public void setValueType(WritableType valueType) {
        this.valueType = valueType;
    }

    public void setOpenedSuffix(String openedSuffix) {
        this.openedSuffix = openedSuffix;
    }

    public String getOpenedSuffix() {
        return this.openedSuffix;
    }

    public void setReadSuffix(String readSuffix) {
        this.readSuffix = readSuffix;
    }

    public String getReadSuffix() {
        return this.readSuffix;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setCheckIdleInterval(int checkIdleInterval) {
        this.checkIdleInterval = checkIdleInterval;
    }

    public int getCheckIdleInterval() {
        return this.checkIdleInterval;
    }

    public List<HdfsProducer.SplitStrategy> getSplitStrategies() {
        return this.splitStrategies;
    }

    public boolean hasSplitStrategies() {
        return !this.splitStrategies.isEmpty();
    }

    public String getSplitStrategy() {
        return this.splitStrategy;
    }

    public void setSplitStrategy(String splitStrategy) {
        this.splitStrategy = splitStrategy;
    }

    public boolean isConnectOnStartup() {
        return this.connectOnStartup;
    }

    public void setConnectOnStartup(boolean connectOnStartup) {
        this.connectOnStartup = connectOnStartup;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getNamedNodes() {
        return this.namedNodes;
    }

    public void setNamedNodes(String namedNodes) {
        this.namedNodes = namedNodes;
    }

    public List<String> getNamedNodeList() {
        return this.namedNodeList;
    }

    public boolean hasClusterConfiguration() {
        return !this.namedNodeList.isEmpty();
    }

    public String getKerberosConfigFileLocation() {
        return this.kerberosConfigFileLocation;
    }

    public void setKerberosConfigFileLocation(String kerberosConfigFileLocation) {
        this.kerberosConfigFileLocation = kerberosConfigFileLocation;
    }

    public String getKerberosUsername() {
        return this.kerberosUsername;
    }

    public void setKerberosUsername(String kerberosUsername) {
        this.kerberosUsername = kerberosUsername;
    }

    public String getKerberosKeytabLocation() {
        return this.kerberosKeytabLocation;
    }

    public void setKerberosKeytabLocation(String kerberosKeytabLocation) {
        this.kerberosKeytabLocation = kerberosKeytabLocation;
    }

    public boolean isKerberosAuthentication() {
        return ObjectHelper.isNotEmpty((String)this.kerberosConfigFileLocation) && ObjectHelper.isNotEmpty((String)this.kerberosUsername) && ObjectHelper.isNotEmpty((String)this.kerberosKeytabLocation);
    }

    public boolean isStreamDownload() {
        return this.streamDownload;
    }

    public void setStreamDownload(boolean streamDownload) {
        this.streamDownload = streamDownload;
    }

    String getFileSystemLabel(String path) {
        if (this.hasClusterConfiguration()) {
            return String.format("%s/%s", this.getHostName(), path);
        }
        return String.format("%s:%s/%s", this.getHostName(), this.getPort(), path);
    }
}

