/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.hdfs.DefaultHdfsFile;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsHelper;
import org.apache.camel.component.hdfs.HdfsInfo;
import org.apache.camel.component.hdfs.HdfsInfoFactory;
import org.apache.camel.component.hdfs.HdfsInputStream;
import org.apache.camel.component.hdfs.HdfsOutputStream;
import org.apache.camel.component.hdfs.Holder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ArrayFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.ReflectionUtils;

class HdfsArrayFileTypeHandler
extends DefaultHdfsFile<ArrayFile.Writer, ArrayFile.Reader> {
    HdfsArrayFileTypeHandler() {
    }

    @Override
    public ArrayFile.Writer createOutputStream(String hdfsPath, HdfsInfoFactory hdfsInfoFactory) {
        try {
            HdfsInfo hdfsInfo = hdfsInfoFactory.newHdfsInfo(hdfsPath);
            HdfsConfiguration endpointConfig = hdfsInfoFactory.getEndpointConfig();
            Class<? extends WritableComparable> valueWritableClass = endpointConfig.getValueType().getWritableClass();
            ArrayFile.Writer rout = new ArrayFile.Writer(hdfsInfo.getConfiguration(), hdfsInfo.getFileSystem(), hdfsPath, valueWritableClass, HdfsHelper.asCompressionType(endpointConfig.getCompressionType()), () -> {});
            return rout;
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public long append(HdfsOutputStream hdfsOutputStream, Object key, Object value, Exchange exchange) {
        try {
            Holder<Integer> valueSize = new Holder<Integer>();
            Writable valueWritable = this.getWritable(value, exchange, valueSize);
            ((ArrayFile.Writer)hdfsOutputStream.getOut()).append(valueWritable);
            return valueSize.getValue().intValue();
        }
        catch (Exception ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public ArrayFile.Reader createInputStream(String hdfsPath, HdfsInfoFactory hdfsInfoFactory) {
        try {
            HdfsInfo hdfsInfo = hdfsInfoFactory.newHdfsInfo(hdfsPath);
            ArrayFile.Reader rin = new ArrayFile.Reader(hdfsInfo.getFileSystem(), hdfsPath, hdfsInfo.getConfiguration());
            return rin;
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public long next(HdfsInputStream hdfsInputStream, Holder<Object> key, Holder<Object> value) {
        try {
            ArrayFile.Reader reader = (ArrayFile.Reader)hdfsInputStream.getIn();
            Holder<Integer> valueSize = new Holder<Integer>();
            Writable valueWritable = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)new Configuration());
            if (reader.next(valueWritable) != null) {
                value.setValue(this.getObject(valueWritable, valueSize));
                return valueSize.getValue().intValue();
            }
            return 0L;
        }
        catch (Exception ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }
}

