/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Map;
import javax.security.auth.login.Configuration;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.hdfs.HdfsEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsComponent.class);

    public HdfsComponent() {
        super(HdfsEndpoint.class);
        this.initHdfs();
    }

    public HdfsComponent(CamelContext context) {
        super(context, HdfsEndpoint.class);
        this.initHdfs();
    }

    protected final Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        HdfsEndpoint hdfsEndpoint = new HdfsEndpoint(uri, this.getCamelContext());
        this.setProperties(hdfsEndpoint.getConfig(), parameters);
        return hdfsEndpoint;
    }

    protected void initHdfs() {
        try {
            URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new FsUrlStreamHandlerFactory());
        }
        catch (Throwable e) {
            LOG.debug("Cannot set URLStreamHandlerFactory due " + e.getMessage() + ". This exception will be ignored.", e);
        }
    }

    static Configuration getJAASConfiguration() {
        Configuration auth = null;
        try {
            auth = Configuration.getConfiguration();
            LOG.trace("Existing JAAS Configuration {}", (Object)auth);
        }
        catch (SecurityException e) {
            LOG.trace("Cannot load existing JAAS configuration", (Throwable)e);
        }
        return auth;
    }

    static void setJAASConfiguration(Configuration auth) {
        if (auth != null) {
            LOG.trace("Restoring existing JAAS Configuration {}", (Object)auth);
            try {
                Configuration.setConfiguration(auth);
            }
            catch (SecurityException e) {
                LOG.trace("Cannot restore JAAS Configuration. This exception is ignored.", (Throwable)e);
            }
        } else {
            LOG.trace("No JAAS Configuration to restore");
        }
    }
}

