/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase.mapping;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Message;
import org.apache.camel.component.hbase.HBaseAttribute;
import org.apache.camel.component.hbase.mapping.CellMappingStrategy;
import org.apache.camel.component.hbase.model.HBaseCell;
import org.apache.camel.component.hbase.model.HBaseData;
import org.apache.camel.component.hbase.model.HBaseRow;

public class HeaderMappingStrategy
implements CellMappingStrategy {
    private HBaseRow resolveRow(Message message, int index) {
        HBaseRow hRow = new HBaseRow();
        HBaseCell hCell = new HBaseCell();
        if (message != null) {
            Class<String> valueClass;
            Object id = message.getHeader(HBaseAttribute.HBASE_ROW_ID.asHeader(index));
            String rowClassName = (String)message.getHeader(HBaseAttribute.HBASE_ROW_TYPE.asHeader(index), String.class);
            Class rowClass = rowClassName == null || rowClassName.isEmpty() ? String.class : message.getExchange().getContext().getClassResolver().resolveClass(rowClassName);
            String columnFamily = (String)message.getHeader(HBaseAttribute.HBASE_FAMILY.asHeader(index));
            String columnName = (String)message.getHeader(HBaseAttribute.HBASE_QUALIFIER.asHeader(index));
            Object value = message.getHeader(HBaseAttribute.HBASE_VALUE.asHeader(index));
            String valueClassName = (String)message.getHeader(HBaseAttribute.HBASE_VALUE_TYPE.asHeader(index), String.class);
            Class<String> clazz = valueClass = valueClassName == null || valueClassName.isEmpty() ? String.class : message.getExchange().getContext().getClassResolver().resolveClass(valueClassName);
            if (id == null && columnFamily == null && columnName == null) {
                return null;
            }
            hRow.setId(id);
            hRow.setRowType(rowClass);
            if (columnFamily != null && columnName != null) {
                hCell.setQualifier(columnName);
                hCell.setFamily(columnFamily);
                hCell.setValue(value);
                hCell.setValueType(valueClass != null ? valueClass : String.class);
                hRow.getCells().add(hCell);
            }
        }
        return hRow;
    }

    @Override
    public HBaseData resolveModel(Message message) {
        int index = 1;
        HBaseData data = new HBaseData();
        LinkedHashMap<Object, HBaseRow> rows = new LinkedHashMap<Object, HBaseRow>();
        HBaseRow hRow = new HBaseRow();
        while (hRow != null) {
            if ((hRow = this.resolveRow(message, index++)) == null) continue;
            if (rows.containsKey(hRow.getId())) {
                ((HBaseRow)rows.get(hRow.getId())).getCells().addAll(hRow.getCells());
                continue;
            }
            rows.put(hRow.getId(), hRow);
        }
        for (Map.Entry rowEntry : rows.entrySet()) {
            data.getRows().add((HBaseRow)rowEntry.getValue());
        }
        return data;
    }

    @Override
    public void applyGetResults(Message message, HBaseData data) {
        message.setHeaders(message.getExchange().getIn().getHeaders());
        int index = 1;
        if (data == null || data.getRows() == null) {
            return;
        }
        for (HBaseRow hRow : data.getRows()) {
            if (hRow.getId() == null) continue;
            Set<HBaseCell> cells = hRow.getCells();
            for (HBaseCell cell : cells) {
                message.setHeader(HBaseAttribute.HBASE_VALUE.asHeader(index++), this.getValueForColumn(cells, cell.getFamily(), cell.getQualifier()));
            }
        }
    }

    @Override
    public void applyScanResults(Message message, HBaseData data) {
        message.setHeaders(message.getExchange().getIn().getHeaders());
        int index = 1;
        if (data == null || data.getRows() == null) {
            return;
        }
        for (HBaseRow hRow : data.getRows()) {
            Set<HBaseCell> cells = hRow.getCells();
            for (HBaseCell cell : cells) {
                message.setHeader(HBaseAttribute.HBASE_ROW_ID.asHeader(index), hRow.getId());
                message.setHeader(HBaseAttribute.HBASE_FAMILY.asHeader(index), (Object)cell.getFamily());
                message.setHeader(HBaseAttribute.HBASE_QUALIFIER.asHeader(index), (Object)cell.getQualifier());
                message.setHeader(HBaseAttribute.HBASE_VALUE.asHeader(index), cell.getValue());
            }
            ++index;
        }
    }

    private Object getValueForColumn(Set<HBaseCell> cells, String family, String qualifier) {
        if (cells != null) {
            for (HBaseCell cell : cells) {
                if (!cell.getQualifier().equals(qualifier) || !cell.getFamily().equals(family)) continue;
                return cell.getValue();
            }
        }
        return null;
    }
}

