/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.hbase.processor.idempotent.HBaseIdempotentRepository;
import org.apache.camel.util.IOHelper;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseIdempotentRepository.class);
    private static final Map<String, byte[]> NAMES = new HashMap<String, byte[]>();

    private HBaseHelper() {
    }

    public static byte[] getHBaseFieldAsBytes(String n) {
        byte[] name = null;
        name = NAMES.get(n);
        if (name == null && n != null) {
            name = n.getBytes();
            NAMES.put(n, name);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Object obj) {
        byte[] byArray;
        if (obj instanceof String) {
            return Bytes.toBytes((String)((String)obj));
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof Byte) {
            return Bytes.toBytes((short)((Byte)obj).byteValue());
        }
        if (obj instanceof Short) {
            return Bytes.toBytes((short)((Short)obj));
        }
        if (obj instanceof Integer) {
            return Bytes.toBytes((int)((Integer)obj));
        }
        if (obj instanceof Long) {
            return Bytes.toBytes((long)((Long)obj));
        }
        if (obj instanceof Double) {
            return Bytes.toBytes((double)((Double)obj));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            byArray = baos.toByteArray();
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                LOG.warn("Error while serializing object. Null will be used.", (Throwable)e);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                IOHelper.close(oos);
                IOHelper.close((Closeable)baos);
                throw throwable;
            }
            IOHelper.close((Closeable)oos);
            IOHelper.close((Closeable)baos);
            return byArray2;
        }
        IOHelper.close((Closeable)oos);
        IOHelper.close((Closeable)baos);
        return byArray;
    }
}

