/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase;

import org.apache.camel.component.hbase.HBaseAttribute;
import org.apache.camel.spi.Metadata;

public interface HBaseConstants {
    @Metadata(label="producer", description="The HBase operation to perform", javaType="String")
    public static final String OPERATION = "CamelHBaseOperation";
    public static final String PUT = "CamelHBasePut";
    public static final String APPEND = "CamelHBaseAppend";
    public static final String INCREMENT = "CamelHBaseIncrement";
    public static final String GET = "CamelHBaseGet";
    public static final String SCAN = "CamelHBaseScan";
    public static final String DELETE = "CamelHBaseDelete";
    @Metadata(label="producer", description="The maximum number of rows to scan.", javaType="Integer")
    public static final String HBASE_MAX_SCAN_RESULTS = "CamelHBaseMaxScanResults";
    @Metadata(label="producer", description="The row to start scanner at or after", javaType="String")
    public static final String FROM_ROW = "CamelHBaseStartRow";
    @Metadata(label="producer", description="The row to end at (exclusive)", javaType="String")
    public static final String STOP_ROW = "CamelHBaseStopRow";
    @Metadata(description="The strategy to use for mapping Camel messages to HBase columns.\n\nSupported values:\n\n* header\n* body", javaType="String")
    public static final String STRATEGY = "CamelMappingStrategy";
    @Metadata(description="The class name of a custom mapping strategy implementation.", javaType="String")
    public static final String STRATEGY_CLASS_NAME = "CamelMappingStrategyClassName";
    @Metadata(label="consumer", description="The marked row id", javaType="byte[]")
    public static final String HBASE_MARKED_ROW_ID = HBaseAttribute.HBASE_MARKED_ROW_ID.asHeader();
}

