/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.list;

import com.hazelcast.collection.IList;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.core.HazelcastInstance;
import java.util.UUID;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.hazelcast.HazelcastDefaultConsumer;
import org.apache.camel.component.hazelcast.listener.CamelItemListener;

public class HazelcastListConsumer
extends HazelcastDefaultConsumer {
    private final IList<Object> queue;
    private UUID listener;

    public HazelcastListConsumer(HazelcastInstance hazelcastInstance, Endpoint endpoint, Processor processor, String cacheName) {
        super(hazelcastInstance, endpoint, processor, cacheName);
        this.queue = hazelcastInstance.getList(cacheName);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.listener = this.queue.addItemListener((ItemListener)new CamelItemListener(this, this.cacheName), true);
    }

    protected void doStop() throws Exception {
        this.queue.removeItemListener(this.listener);
        super.doStop();
    }
}

