/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.hazelcast;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IMap;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.IdempotentRepository;

public class HazelcastIdempotentRepository
extends ServiceSupport
implements IdempotentRepository<String> {
    private String repositoryName;
    private IMap<String, Object> repo;

    public HazelcastIdempotentRepository() {
        this(HazelcastIdempotentRepository.class.getSimpleName());
    }

    public HazelcastIdempotentRepository(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    protected void doStart() throws Exception {
        this.repo = Hazelcast.getMap((String)this.repositoryName);
    }

    protected void doStop() throws Exception {
    }

    public boolean add(String key) {
        if (this.contains(key)) {
            return false;
        }
        this.repo.put((Object)key, (Object)false);
        return true;
    }

    public boolean confirm(String key) {
        if (this.contains(key)) {
            this.repo.put((Object)key, (Object)true);
            return true;
        }
        return false;
    }

    public boolean contains(String key) {
        return this.repo.containsKey((Object)key);
    }

    public boolean remove(String key) {
        if (this.contains(key)) {
            this.repo.remove((Object)key);
            return true;
        }
        return false;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }
}

