/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.list;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IList;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.impl.DefaultProducer;

public class HazelcastListProducer
extends DefaultProducer {
    private final IList<Object> list;
    private final HazelcastComponentHelper helper = new HazelcastComponentHelper();

    public HazelcastListProducer(Endpoint endpoint, String listName) {
        super(endpoint);
        this.list = Hazelcast.getList((String)listName);
    }

    public void process(Exchange exchange) throws Exception {
        Map headers = exchange.getIn().getHeaders();
        int operation = -1;
        Integer pos = null;
        if (headers.containsKey("CamelHazelcastObjectIndex")) {
            if (!(headers.get("CamelHazelcastObjectIndex") instanceof Integer)) {
                throw new IllegalArgumentException("OBJECT_POS Should be of type Integer");
            }
            pos = (Integer)headers.get("CamelHazelcastObjectIndex");
        }
        if (headers.containsKey("CamelHazelcastOperationType")) {
            operation = headers.get("CamelHazelcastOperationType") instanceof String ? this.helper.lookupOperationNumber((String)headers.get("CamelHazelcastOperationType")) : ((Integer)headers.get("CamelHazelcastOperationType")).intValue();
        }
        switch (operation) {
            case 31: {
                this.add(pos, exchange);
                break;
            }
            case 3: {
                this.get(pos, exchange);
                break;
            }
            case 22: {
                this.set(pos, exchange);
                break;
            }
            case 10: {
                this.remove(pos, exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the LIST cache.", operation, "CamelHazelcastOperationType"));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void add(Integer pos, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        if (null == pos) {
            this.list.add(body);
        } else {
            this.list.add(pos.intValue(), body);
        }
    }

    private void get(Integer pos, Exchange exchange) {
        exchange.getOut().setBody(this.list.get(pos.intValue()));
    }

    private void set(Integer pos, Exchange exchange) {
        if (null == pos) {
            throw new IllegalArgumentException("Empty position for set operation.");
        }
        Object body = exchange.getIn().getBody();
        this.list.set(pos.intValue(), body);
    }

    private void remove(Integer pos, Exchange exchange) {
        if (null == pos) {
            Object body = exchange.getIn().getBody();
            this.list.remove(body);
        } else {
            int position = pos;
            this.list.remove(position);
        }
    }
}

