/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.atomicnumber;

import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.Hazelcast;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.impl.DefaultProducer;

public class HazelcastAtomicnumberProducer
extends DefaultProducer {
    private final AtomicNumber atomicnumber;
    private final HazelcastComponentHelper helper = new HazelcastComponentHelper();

    public HazelcastAtomicnumberProducer(Endpoint endpoint, String cacheName) {
        super(endpoint);
        this.atomicnumber = Hazelcast.getAtomicNumber((String)cacheName);
    }

    public void process(Exchange exchange) throws Exception {
        Map headers = exchange.getIn().getHeaders();
        int operation = -1;
        if (headers.containsKey("CamelHazelcastOperationType")) {
            operation = headers.get("CamelHazelcastOperationType") instanceof String ? this.helper.lookupOperationNumber((String)headers.get("CamelHazelcastOperationType")) : ((Integer)headers.get("CamelHazelcastOperationType")).intValue();
        }
        switch (operation) {
            case 20: {
                this.increment(exchange);
                break;
            }
            case 21: {
                this.decrement(exchange);
                break;
            }
            case 22: {
                this.set(exchange);
                break;
            }
            case 3: {
                this.get(exchange);
                break;
            }
            case 23: {
                this.destroy();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the ATOMICNUMBER.", operation, "CamelHazelcastOperationType"));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void get(Exchange exchange) {
        exchange.getOut().setBody((Object)this.atomicnumber.get());
    }

    private void increment(Exchange exchange) {
        exchange.getOut().setBody((Object)this.atomicnumber.incrementAndGet());
    }

    private void decrement(Exchange exchange) {
        exchange.getOut().setBody((Object)this.atomicnumber.decrementAndGet());
    }

    private void set(Exchange exchange) {
        this.atomicnumber.set(((Long)exchange.getIn().getBody(Long.class)).longValue());
    }

    private void destroy() {
        this.atomicnumber.destroy();
    }
}

