/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.seda;

import com.hazelcast.core.Hazelcast;
import java.util.concurrent.BlockingQueue;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.hazelcast.HazelcastComponent;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaConfiguration;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaConsumer;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

public class HazelcastSedaEndpoint
extends DefaultEndpoint {
    private final BlockingQueue queue;
    private final HazelcastSedaConfiguration configuration;

    public HazelcastSedaEndpoint(String uri, HazelcastComponent component, HazelcastSedaConfiguration configuration) {
        super(uri, (Component)component);
        this.queue = Hazelcast.getQueue((String)configuration.getQueueName());
        this.configuration = configuration;
        if (ObjectHelper.isEmpty((Object)configuration.getQueueName())) {
            throw new IllegalArgumentException("Queue name is missing.");
        }
    }

    public Producer createProducer() throws Exception {
        return new HazelcastSedaProducer(this, this.getQueue());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new HazelcastSedaConsumer((Endpoint)this, processor);
    }

    public BlockingQueue getQueue() {
        return this.queue;
    }

    public HazelcastSedaConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isSingleton() {
        return true;
    }
}

