/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.seda;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastSedaConsumer
extends DefaultConsumer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastSedaConsumer.class);
    private final HazelcastSedaEndpoint endpoint;
    private final AsyncProcessor processor;
    private ExecutorService executor;

    public HazelcastSedaConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = (HazelcastSedaEndpoint)endpoint;
        this.processor = AsyncProcessorTypeConverter.convert((Processor)processor);
    }

    protected void doStart() throws Exception {
        int concurrentConsumers = this.endpoint.getConfiguration().getConcurrentConsumers();
        this.executor = this.endpoint.getCamelContext().getExecutorServiceStrategy().newFixedThreadPool((Object)this, this.endpoint.getEndpointUri(), concurrentConsumers);
        for (int i = 0; i < concurrentConsumers; ++i) {
            this.executor.execute(this);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceStrategy().shutdownNow(this.executor);
            this.executor = null;
        }
        super.doStop();
    }

    @Override
    public void run() {
        BlockingQueue queue = this.endpoint.getQueue();
        while (queue != null && this.isRunAllowed()) {
            DefaultExchange exchange = new DefaultExchange(this.getEndpoint().getCamelContext());
            try {
                Object body = queue.poll(this.endpoint.getConfiguration().getPollInterval(), TimeUnit.MILLISECONDS);
                if (body == null) continue;
                exchange.getIn().setBody(body);
                try {
                    this.processor.process((Exchange)exchange, new AsyncCallback(){

                        public void done(boolean sync) {
                        }
                    });
                    if (exchange.getException() == null) continue;
                    this.getExceptionHandler().handleException("Error processing exchange", (Exchange)exchange, (Throwable)exchange.getException());
                }
                catch (Exception e) {
                    LOG.error("Hzlq Exception caught: " + e, (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Hzlq Consumer Interrupted: " + e, (Throwable)e);
            }
            catch (Throwable e) {
                this.getExceptionHandler().handleException("Error processing exchange", (Exchange)exchange, e);
            }
        }
    }
}

