/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.HazelcastOperation;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HazelcastDefaultComponent
extends DefaultComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastDefaultComponent.class);
    private final Set<HazelcastInstance> customHazelcastInstances = new LinkedHashSet<HazelcastInstance>();
    @Metadata(label="advanced")
    private HazelcastInstance hazelcastInstance;
    @Metadata(label="advanced", defaultValue="node")
    private String hazelcastMode = "node";

    public HazelcastDefaultComponent() {
    }

    public HazelcastDefaultComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        HazelcastInstance hzInstance = ObjectHelper.equal((Object)this.getHazelcastMode(), (Object)"node") ? this.getOrCreateHzInstance(this.getCamelContext(), parameters) : this.getOrCreateHzClientInstance(this.getCamelContext(), parameters);
        String defaultOperation = (String)this.getAndRemoveOrResolveReferenceParameter(parameters, "operation", String.class);
        if (defaultOperation == null) {
            defaultOperation = (String)this.getAndRemoveOrResolveReferenceParameter(parameters, "defaultOperation", String.class);
        }
        HazelcastDefaultEndpoint endpoint = this.doCreateEndpoint(uri, remaining, parameters, hzInstance);
        if (defaultOperation != null) {
            endpoint.setDefaultOperation(HazelcastOperation.getHazelcastOperation(defaultOperation));
        }
        return endpoint;
    }

    protected abstract HazelcastDefaultEndpoint doCreateEndpoint(String var1, String var2, Map<String, Object> var3, HazelcastInstance var4) throws Exception;

    public void doStart() throws Exception {
        super.doStart();
    }

    public void doStop() throws Exception {
        for (HazelcastInstance hazelcastInstance : this.customHazelcastInstances) {
            hazelcastInstance.getLifecycleService().shutdown();
        }
        this.customHazelcastInstances.clear();
        super.doStop();
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public String getHazelcastMode() {
        return this.hazelcastMode;
    }

    public void setHazelcastMode(String hazelcastMode) {
        this.hazelcastMode = hazelcastMode;
    }

    protected HazelcastInstance getOrCreateHzInstance(CamelContext context, Map<String, Object> parameters) throws Exception {
        HazelcastInstance hzInstance = null;
        Config config = null;
        hzInstance = (HazelcastInstance)this.resolveAndRemoveReferenceParameter(parameters, "hazelcastInstance", HazelcastInstance.class);
        if (hzInstance == null && parameters.get("hazelcastInstanceName") != null) {
            hzInstance = Hazelcast.getHazelcastInstanceByName((String)((String)parameters.get("hazelcastInstanceName")));
        }
        if (hzInstance == null) {
            config = (Config)this.resolveAndRemoveReferenceParameter(parameters, "hazelcastConfig", Config.class);
            if (config == null) {
                String configUri = (String)this.getAndRemoveParameter(parameters, "hazelcastConfigUri", String.class);
                if (configUri != null) {
                    configUri = this.getCamelContext().resolvePropertyPlaceholders(configUri);
                }
                if (configUri != null) {
                    InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)configUri);
                    config = new XmlConfigBuilder(is).build();
                }
            }
            if (this.hazelcastInstance == null && config == null) {
                config = new XmlConfigBuilder().build();
                config.getProperties().setProperty("hazelcast.version.check.enabled", "false");
                config.getProperties().setProperty("hazelcast.phone.home.enabled", "false");
                hzInstance = Hazelcast.newHazelcastInstance((Config)config);
            } else if (config != null) {
                hzInstance = ObjectHelper.isNotEmpty((Object)config.getInstanceName()) ? Hazelcast.getOrCreateHazelcastInstance((Config)config) : Hazelcast.newHazelcastInstance((Config)config);
            }
            if (hzInstance != null && this.customHazelcastInstances.add(hzInstance)) {
                LOGGER.debug("Add managed HZ instance {}", (Object)hzInstance.getName());
            }
        }
        return hzInstance == null ? this.hazelcastInstance : hzInstance;
    }

    protected HazelcastInstance getOrCreateHzClientInstance(CamelContext context, Map<String, Object> parameters) throws Exception {
        HazelcastInstance hzInstance = null;
        ClientConfig config = null;
        hzInstance = (HazelcastInstance)this.resolveAndRemoveReferenceParameter(parameters, "hazelcastInstance", HazelcastInstance.class);
        if (hzInstance == null && parameters.get("hazelcastInstanceName") != null) {
            hzInstance = Hazelcast.getHazelcastInstanceByName((String)((String)parameters.get("hazelcastInstanceName")));
        }
        if (hzInstance == null) {
            config = (ClientConfig)this.resolveAndRemoveReferenceParameter(parameters, "hazelcastConfig", ClientConfig.class);
            if (config == null) {
                String configUri = (String)this.getAndRemoveParameter(parameters, "hazelcastConfigUri", String.class);
                if (configUri != null) {
                    configUri = this.getCamelContext().resolvePropertyPlaceholders(configUri);
                }
                if (configUri != null) {
                    InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)configUri);
                    config = new XmlClientConfigBuilder(is).build();
                }
            }
            if (this.hazelcastInstance == null && config == null) {
                config = new XmlClientConfigBuilder().build();
                config.getProperties().setProperty("hazelcast.version.check.enabled", "false");
                config.getProperties().setProperty("hazelcast.phone.home.enabled", "false");
                hzInstance = HazelcastClient.newHazelcastClient((ClientConfig)config);
            } else if (config != null) {
                hzInstance = HazelcastClient.newHazelcastClient((ClientConfig)config);
            }
            if (hzInstance != null && this.customHazelcastInstances.add(hzInstance)) {
                LOGGER.debug("Add managed HZ instance {}", (Object)hzInstance.getName());
            }
        }
        return hzInstance == null ? this.hazelcastInstance : hzInstance;
    }
}

