/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.impl.DefaultEndpoint;

public abstract class HazelcastDefaultEndpoint
extends DefaultEndpoint {
    protected final String cacheName;
    protected HazelcastInstance hazelcastInstance;
    private int defaultOperation = -1;
    private final HazelcastComponentHelper helper = new HazelcastComponentHelper();

    public HazelcastDefaultEndpoint(HazelcastInstance hazelcastInstance, String endpointUri, Component component) {
        this(hazelcastInstance, endpointUri, component, null);
    }

    public HazelcastDefaultEndpoint(HazelcastInstance hazelcastInstance, String endpointUri, Component component, String cacheName) {
        super(endpointUri, component);
        this.cacheName = cacheName;
        this.hazelcastInstance = hazelcastInstance;
    }

    public abstract Consumer createConsumer(Processor var1) throws Exception;

    public abstract Producer createProducer() throws Exception;

    public boolean isSingleton() {
        return true;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void configureProperties(Map<String, Object> options) {
        super.configureProperties(options);
        this.defaultOperation = this.helper.extractOperationNumber(options.remove("operation"), -1);
    }

    public int getDefaultOperation() {
        return this.defaultOperation;
    }
}

