/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice.support;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.apache.camel.guice.support.Closer;

public class CompositeCloser
implements Closer {
    private final Iterable<Closer> closers;

    public CompositeCloser(Iterable<Closer> closers) {
        this.closers = closers;
    }

    @Override
    public void close(Object object) throws Throwable {
        for (Closer closer : this.closers) {
            closer.close(object);
        }
    }

    public static Closer newInstance(Collection<Closer> closers) {
        if (closers.isEmpty()) {
            return null;
        }
        if (closers.size() == 1) {
            return (Closer)Iterables.getOnlyElement(closers);
        }
        return new CompositeCloser(closers);
    }
}

