/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.guava.eventbus;

import com.google.common.eventbus.EventBus;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.guava.eventbus.GuavaEventBusConsumer;
import org.apache.camel.component.guava.eventbus.GuavaEventBusProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.10.0", scheme="guava-eventbus", title="Guava EventBus", syntax="guava-eventbus:eventBusRef", category={Category.MESSAGING})
public class GuavaEventBusEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    private EventBus eventBus;
    @UriPath
    private String eventBusRef;
    @UriParam
    private Class<?> eventClass;
    @UriParam
    private Class<?> listenerInterface;

    public GuavaEventBusEndpoint(String endpointUri, Component component, EventBus eventBus, Class<?> listenerInterface) {
        super(endpointUri, component);
        this.eventBus = eventBus;
        this.listenerInterface = listenerInterface;
    }

    public Producer createProducer() throws Exception {
        return new GuavaEventBusProducer((Endpoint)this, this.eventBus);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        GuavaEventBusConsumer answer = new GuavaEventBusConsumer(this, processor, this.eventBus, this.eventClass, this.listenerInterface);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    public String getEventBusRef() {
        return this.eventBusRef;
    }

    public void setEventBusRef(String eventBusRef) {
        this.eventBusRef = eventBusRef;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public Class<?> getEventClass() {
        return this.eventClass;
    }

    public void setEventClass(Class<?> eventClass) {
        this.eventClass = eventClass;
    }

    public Class<?> getListenerInterface() {
        return this.listenerInterface;
    }

    public void setListenerInterface(Class<?> listenerInterface) {
        this.listenerInterface = listenerInterface;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.eventBusRef != null && this.eventBus == null) {
            this.eventBus = (EventBus)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.eventBusRef, EventBus.class);
        }
    }
}

