/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.server;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.grpc.GrpcConsumer;
import org.apache.camel.component.grpc.GrpcConsumerStrategy;
import org.apache.camel.component.grpc.GrpcEndpoint;
import org.apache.camel.component.grpc.server.GrpcHeaderInterceptor;
import org.apache.camel.component.grpc.server.GrpcRequestAbstractStreamObserver;
import org.apache.camel.component.grpc.server.GrpcRequestAggregationStreamObserver;
import org.apache.camel.component.grpc.server.GrpcRequestDelegationStreamObserver;
import org.apache.camel.component.grpc.server.GrpcRequestPropagationStreamObserver;

public class GrpcMethodHandler {
    protected final GrpcConsumer consumer;

    public GrpcMethodHandler(GrpcConsumer consumer) {
        this.consumer = consumer;
    }

    public void handle(Object body, StreamObserver<Object> responseObserver, String methodName) throws Exception {
        Map<String, Object> grcpHeaders = this.populateGrpcHeaders(methodName);
        GrpcEndpoint endpoint = (GrpcEndpoint)this.consumer.getEndpoint();
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody(body);
        exchange.getIn().setHeaders(grcpHeaders);
        if (endpoint.getConfiguration().isRouteControlledStreamObserver()) {
            exchange.setProperty("grpcResponseObserver", responseObserver);
            this.invokeRoute(endpoint, exchange);
            return;
        }
        this.invokeRoute(endpoint, exchange);
        if (exchange.isFailed()) {
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(exchange.getException().getMessage()).withCause((Throwable)exchange.getException()).asRuntimeException());
        } else {
            Object responseBody = exchange.getIn().getBody();
            if (responseBody instanceof List) {
                List responseList = (List)responseBody;
                responseList.forEach(arg_0 -> responseObserver.onNext(arg_0));
            } else {
                responseObserver.onNext(responseBody);
            }
            responseObserver.onCompleted();
        }
    }

    private void invokeRoute(GrpcEndpoint endpoint, Exchange exchange) throws Exception {
        if (endpoint.getConfiguration().isSynchronous()) {
            this.consumer.getProcessor().process(exchange);
        } else {
            this.consumer.getAsyncProcessor().process(exchange);
        }
    }

    public StreamObserver<Object> handleForConsumerStrategy(StreamObserver<Object> responseObserver, String methodName) {
        GrpcRequestAbstractStreamObserver requestObserver;
        Map<String, Object> grcpHeaders = this.populateGrpcHeaders(methodName);
        GrpcEndpoint endpoint = (GrpcEndpoint)this.consumer.getEndpoint();
        if (this.consumer.getConfiguration().getConsumerStrategy() == GrpcConsumerStrategy.AGGREGATION) {
            requestObserver = new GrpcRequestAggregationStreamObserver(endpoint, this.consumer, responseObserver, grcpHeaders);
        } else if (this.consumer.getConfiguration().getConsumerStrategy() == GrpcConsumerStrategy.PROPAGATION) {
            requestObserver = new GrpcRequestPropagationStreamObserver(endpoint, this.consumer, responseObserver, grcpHeaders);
        } else if (this.consumer.getConfiguration().getConsumerStrategy() == GrpcConsumerStrategy.DELEGATION) {
            requestObserver = new GrpcRequestDelegationStreamObserver(endpoint, this.consumer, responseObserver, grcpHeaders);
        } else {
            throw new IllegalArgumentException("gRPC processing strategy not implemented " + String.valueOf((Object)this.consumer.getConfiguration().getConsumerStrategy()));
        }
        return requestObserver;
    }

    private Map<String, Object> populateGrpcHeaders(String methodName) {
        HashMap<String, Object> grpcHeaders = new HashMap<String, Object>();
        grpcHeaders.put(GrpcHeaderInterceptor.USER_AGENT_CONTEXT_KEY.toString(), GrpcHeaderInterceptor.USER_AGENT_CONTEXT_KEY.get());
        grpcHeaders.put(GrpcHeaderInterceptor.CONTENT_TYPE_CONTEXT_KEY.toString(), GrpcHeaderInterceptor.CONTENT_TYPE_CONTEXT_KEY.get());
        grpcHeaders.put("CamelGrpcMethodName", methodName);
        return grpcHeaders;
    }
}

