/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Service;
import org.apache.camel.language.groovy.GroovyExpression;
import org.apache.camel.language.groovy.GroovyValidationException;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.SimpleEventNotifierSupport;
import org.apache.camel.support.TypedLanguageSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Language(value="groovy")
public class GroovyLanguage
extends TypedLanguageSupport
implements ScriptingLanguage,
Service {
    private static final Logger LOG = LoggerFactory.getLogger(GroovyLanguage.class);
    private final boolean loadExternalResource;
    private final Map<String, GroovyClassService> scriptCache;
    private EventNotifier notifier;

    private GroovyLanguage(Map<String, GroovyClassService> scriptCache, boolean loadExternalResource) {
        this.scriptCache = scriptCache;
        this.loadExternalResource = loadExternalResource;
    }

    public GroovyLanguage() {
        this(LRUCacheFactory.newLRUSoftCache((int)16, (int)1000, (boolean)true), true);
    }

    public void start() {
        String profile;
        if (this.getCamelContext() != null && "dev".equals(profile = this.getCamelContext().getCamelContextExtension().getProfile()) && this.notifier == null) {
            this.notifier = new ReloadNotifier();
            this.getCamelContext().getManagementStrategy().addEventNotifier(this.notifier);
        }
    }

    public void stop() {
        ServiceHelper.stopService(this.scriptCache.values());
        this.scriptCache.clear();
        if (this.notifier != null) {
            this.getCamelContext().getManagementStrategy().removeEventNotifier(this.notifier);
            this.notifier = null;
        }
    }

    public static GroovyExpression groovy(String expression) {
        return new GroovyLanguage().createExpression(expression);
    }

    public GroovyExpression createPredicate(String expression) {
        return this.createExpression(expression);
    }

    public GroovyExpression createExpression(String expression) {
        expression = this.loadResource(expression);
        return new GroovyExpression(expression);
    }

    public <T> T evaluate(String script, Map<String, Object> bindings, Class<T> resultType) {
        Class clazz;
        if (this.loadExternalResource) {
            script = this.loadResource(script);
        }
        if ((clazz = this.getScriptFromCache(script)) == null) {
            ClassLoader cl = this.getCamelContext().getApplicationContextClassLoader();
            GroovyShell shell = new GroovyShell(cl);
            clazz = shell.getClassLoader().parseClass(script);
            this.addScriptToCache(script, clazz);
        }
        Script gs = (Script)ObjectHelper.newInstance(clazz, Script.class);
        if (bindings != null) {
            gs.setBinding(new Binding(bindings));
        }
        gs.getBinding().setVariable("log", (Object)LOG);
        Object value = gs.run();
        return (T)this.getCamelContext().getTypeConverter().convertTo(resultType, value);
    }

    public boolean validateExpression(String expression) throws GroovyValidationException {
        DefaultExchange dummy = new DefaultExchange(this.getCamelContext());
        HashMap<String, Object> globalVariables = new HashMap<String, Object>();
        try {
            GroovyExpression ge = this.createExpression(expression);
            Script script = ge.instantiateScript((Exchange)dummy, globalVariables);
            script.setBinding(ge.createBinding((Exchange)dummy, globalVariables));
            script.run();
        }
        catch (Exception e) {
            throw new GroovyValidationException(expression, e);
        }
        return true;
    }

    public boolean validatePredicate(String expression) throws GroovyValidationException {
        return this.validateExpression(expression);
    }

    Class<Script> getScriptFromCache(String script) {
        GroovyClassService cached = this.scriptCache.get(script);
        if (cached == null) {
            return null;
        }
        return cached.script;
    }

    void addScriptToCache(String script, Class<Script> scriptClass) {
        this.scriptCache.put(script, new GroovyClassService(scriptClass));
    }

    private final class ReloadNotifier
    extends SimpleEventNotifierSupport {
        private ReloadNotifier() {
        }

        public void notify(CamelEvent event) throws Exception {
            if (event instanceof CamelEvent.CamelContextReloadingEvent || event instanceof CamelEvent.RouteReloadedEvent) {
                ServiceHelper.stopService(GroovyLanguage.this.scriptCache.values());
                GroovyLanguage.this.scriptCache.clear();
            }
        }
    }

    private static final class GroovyClassService
    implements Service {
        private final Class<Script> script;

        private GroovyClassService(Class<Script> script) {
            this.script = script;
        }

        public void start() {
        }

        public void stop() {
            InvokerHelper.removeClass(this.script);
        }
    }

    public static class Builder {
        private final Map<String, GroovyClassService> cache = new HashMap<String, GroovyClassService>();

        public void addScript(String content, Class<Script> scriptClass) {
            this.cache.put(content, new GroovyClassService(scriptClass));
        }

        public GroovyLanguage build() {
            return new GroovyLanguage(Collections.unmodifiableMap(this.cache), false);
        }
    }
}

