/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.storage.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.component.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="google-storage:application-cloudevents", description="Adds CloudEvent headers to the Camel message with Google Storage downloadTo response information")
public class GoogleStorageCloudEventDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.google.storage.downloadTo");
        if (message.getHeaders().containsKey("CamelGoogleCloudStorageBucketName")) {
            headers.put("CamelCloudEventSource", "google.storage.bucket." + (String)message.getHeader("CamelGoogleCloudStorageBucketName", String.class));
        }
        headers.put("CamelCloudEventSubject", message.getHeader("CamelGoogleCloudStorageObjectName", String.class));
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
    }
}

