/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsub.consumer;

import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.pubsub.consumer.GooglePubsubAcknowledge;

public class AcknowledgeSync
implements GooglePubsubAcknowledge {
    private final Callable<SubscriberStub> subscriberStubSupplier;
    private final String subscriptionName;

    public AcknowledgeSync(Callable<SubscriberStub> subscriberStubSupplier, String subscriptionName) {
        this.subscriberStubSupplier = subscriberStubSupplier;
        this.subscriptionName = subscriptionName;
    }

    @Override
    public void ack(Exchange exchange) {
        AcknowledgeRequest ackRequest = AcknowledgeRequest.newBuilder().addAllAckIds(this.getAckIdList(exchange)).setSubscription(this.subscriptionName).build();
        try (SubscriberStub subscriber = this.subscriberStubSupplier.call();){
            subscriber.acknowledgeCallable().call((Object)ackRequest);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    @Override
    public void nack(Exchange exchange) {
        ModifyAckDeadlineRequest nackRequest = ModifyAckDeadlineRequest.newBuilder().addAllAckIds(this.getAckIdList(exchange)).setSubscription(this.subscriptionName).setAckDeadlineSeconds(0).build();
        try (SubscriberStub subscriber = this.subscriberStubSupplier.call();){
            subscriber.modifyAckDeadlineCallable().call((Object)nackRequest);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private List<String> getAckIdList(Exchange exchange) {
        String ackId;
        ArrayList<String> ackList = new ArrayList<String>();
        if (exchange.getIn().getBody() instanceof List) {
            for (Object body : (List)exchange.getIn().getBody(List.class)) {
                String ackId2;
                if (!(body instanceof Exchange) || null == (ackId2 = (String)exchange.getIn().getHeader("CamelGooglePubsubMsgAckId", String.class))) continue;
                ackList.add(ackId2);
            }
        }
        if (null != (ackId = (String)exchange.getIn().getHeader("CamelGooglePubsubMsgAckId", String.class))) {
            ackList.add(ackId);
        }
        return ackList;
    }
}

