/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsub;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.Base64;
import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.PubsubScopes;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooglePubsubConnectionFactory {
    private static JsonFactory jsonFactory = new JacksonFactory();
    private final Logger logger = LoggerFactory.getLogger(GooglePubsubConnectionFactory.class);
    private String serviceAccount;
    private String serviceAccountKey;
    private String credentialsFileLocation;
    private String serviceURL;
    private Pubsub client;

    public synchronized Pubsub getDefaultClient() throws Exception {
        if (this.client == null) {
            this.client = this.buildClient();
        }
        return this.client;
    }

    public Pubsub getMultiThreadClient(int parallelThreads) throws Exception {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setDefaultMaxPerRoute(parallelThreads);
        cm.setMaxTotal(parallelThreads);
        CloseableHttpClient httpClient = HttpClients.createMinimal((HttpClientConnectionManager)cm);
        return this.buildClient((HttpTransport)new ApacheHttpTransport((HttpClient)httpClient));
    }

    private Pubsub buildClient() throws Exception {
        return this.buildClient((HttpTransport)GoogleNetHttpTransport.newTrustedTransport());
    }

    private Pubsub buildClient(HttpTransport httpTransport) throws Exception {
        GoogleCredential credential = null;
        if (!ObjectHelper.isEmpty((Object)this.serviceAccount) && !ObjectHelper.isEmpty((Object)this.serviceAccountKey)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Service Account and Key have been set explicitly. Initialising PubSub using Service Account " + this.serviceAccount);
            }
            credential = this.createFromAccountKeyPair(httpTransport);
        }
        if (credential == null && !ObjectHelper.isEmpty((Object)this.credentialsFileLocation)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Key File Name has been set explicitly. Initialising PubSub using Key File " + this.credentialsFileLocation);
            }
            credential = this.createFromFile();
        }
        if (credential == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No explicit Service Account or Key File Name have been provided. Initialising PubSub using defaults ");
            }
            credential = this.createDefault();
        }
        Pubsub.Builder builder = new Pubsub.Builder(httpTransport, jsonFactory, credential).setApplicationName("camel-google-pubsub");
        if (this.serviceURL != null) {
            builder.setRootUrl(this.serviceURL);
        }
        return builder.build();
    }

    private GoogleCredential createFromFile() throws Exception {
        GoogleCredential credential = GoogleCredential.fromStream((InputStream)new FileInputStream(this.credentialsFileLocation));
        if (credential.createScopedRequired()) {
            credential = credential.createScoped((Collection)PubsubScopes.all());
        }
        return credential;
    }

    private GoogleCredential createDefault() throws Exception {
        GoogleCredential credential = GoogleCredential.getApplicationDefault();
        List<String> pubSubScopes = Collections.singletonList("https://www.googleapis.com/auth/pubsub");
        if (credential.createScopedRequired()) {
            credential = credential.createScoped(pubSubScopes);
        }
        return credential;
    }

    private GoogleCredential createFromAccountKeyPair(HttpTransport httpTransport) {
        try {
            GoogleCredential credential = new GoogleCredential.Builder().setTransport(httpTransport).setJsonFactory(jsonFactory).setServiceAccountId(this.serviceAccount).setServiceAccountScopes((Collection)PubsubScopes.all()).setServiceAccountPrivateKey(this.getPrivateKeyFromString(this.serviceAccountKey)).build();
            return credential;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PrivateKey getPrivateKeyFromString(String serviceKeyPem) {
        PrivateKey privateKey = null;
        try {
            String privKeyPEM = serviceKeyPem.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("\r", "").replace("\n", "");
            byte[] encoded = Base64.decodeBase64((String)privKeyPEM);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
            privateKey = KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        }
        catch (Exception e) {
            String error = "Constructing Private Key from PEM string failed: " + e.getMessage();
            this.logger.error(error, (Throwable)e);
            throw new RuntimeException(e);
        }
        return privateKey;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public GooglePubsubConnectionFactory setServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        this.resetClient();
        return this;
    }

    public String getServiceAccountKey() {
        return this.serviceAccountKey;
    }

    public GooglePubsubConnectionFactory setServiceAccountKey(String serviceAccountKey) {
        this.serviceAccountKey = serviceAccountKey;
        this.resetClient();
        return this;
    }

    public String getCredentialsFileLocation() {
        return this.credentialsFileLocation;
    }

    public GooglePubsubConnectionFactory setCredentialsFileLocation(String credentialsFileLocation) {
        this.credentialsFileLocation = credentialsFileLocation;
        this.resetClient();
        return this;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public GooglePubsubConnectionFactory setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
        this.resetClient();
        return this;
    }

    private synchronized void resetClient() {
        this.client = null;
    }
}

