/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsub.consumer;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.services.pubsub.model.AcknowledgeRequest;
import com.google.api.services.pubsub.model.ModifyAckDeadlineRequest;
import java.util.List;
import org.apache.camel.component.google.pubsub.GooglePubsubEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PubsubAcknowledgement {
    protected Logger logger;
    private final String subscriptionFullName;
    private final GooglePubsubEndpoint endpoint;

    public PubsubAcknowledgement(GooglePubsubEndpoint endpoint) {
        this.endpoint = endpoint;
        this.subscriptionFullName = String.format("projects/%s/subscriptions/%s", endpoint.getProjectId(), endpoint.getDestinationName());
        String loggerId = endpoint.getLoggerId();
        if (Strings.isNullOrEmpty((String)loggerId)) {
            loggerId = this.getClass().getName();
        }
        this.logger = LoggerFactory.getLogger((String)loggerId);
    }

    void acknowledge(List<String> ackIdList) {
        AcknowledgeRequest ackRequest = new AcknowledgeRequest().setAckIds(ackIdList);
        try {
            this.endpoint.getPubsub().projects().subscriptions().acknowledge(this.subscriptionFullName, ackRequest).execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void resetAckDeadline(List<String> ackIdList, Integer seconds) {
        ModifyAckDeadlineRequest nackRequest = new ModifyAckDeadlineRequest().setAckIds(ackIdList).setAckDeadlineSeconds(seconds);
        try {
            this.endpoint.getPubsub().projects().subscriptions().modifyAckDeadline(this.subscriptionFullName, nackRequest).execute();
        }
        catch (Exception e) {
            this.logger.warn("Unable to reset ack deadline " + ackIdList, (Throwable)e);
        }
    }
}

