/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.services.drive.Drive;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.drive.GoogleDriveClientFactory;
import org.apache.camel.component.google.drive.GoogleDriveComponent;
import org.apache.camel.component.google.drive.GoogleDriveConfiguration;
import org.apache.camel.component.google.drive.GoogleDriveConsumer;
import org.apache.camel.component.google.drive.GoogleDriveProducer;
import org.apache.camel.component.google.drive.internal.GoogleDriveApiCollection;
import org.apache.camel.component.google.drive.internal.GoogleDriveApiName;
import org.apache.camel.component.google.drive.internal.GoogleDrivePropertiesHelper;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.camel.support.component.ApiName;

@UriEndpoint(firstVersion="2.14.0", scheme="google-drive", title="Google Drive", syntax="google-drive:apiName/methodName", apiSyntax="apiName/methodName", consumerPrefix="consumer", category={Category.FILE, Category.CLOUD, Category.API})
public class GoogleDriveEndpoint
extends AbstractApiEndpoint<GoogleDriveApiName, GoogleDriveConfiguration> {
    private Object apiProxy;
    @UriParam
    private GoogleDriveConfiguration configuration;
    @UriParam
    private GoogleDriveClientFactory clientFactory;

    public GoogleDriveEndpoint(String uri, GoogleDriveComponent component, GoogleDriveApiName apiName, String methodName, GoogleDriveConfiguration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, GoogleDriveApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.configuration = endpointConfiguration;
    }

    public Producer createProducer() throws Exception {
        return new GoogleDriveProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        GoogleDriveConsumer consumer = new GoogleDriveConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected ApiMethodPropertiesHelper<GoogleDriveConfiguration> getPropertiesHelper() {
        return GoogleDrivePropertiesHelper.getHelper(this.getCamelContext());
    }

    protected String getThreadProfileName() {
        return "CamelGoogleDrive";
    }

    protected void afterConfigureProperties() {
        switch ((GoogleDriveApiName)this.apiName) {
            case DRIVE_ABOUT: {
                this.apiProxy = this.getClient().about();
                break;
            }
            case DRIVE_CHANGES: {
                this.apiProxy = this.getClient().changes();
                break;
            }
            case DRIVE_CHANNELS: {
                this.apiProxy = this.getClient().channels();
                break;
            }
            case DRIVE_COMMENTS: {
                this.apiProxy = this.getClient().comments();
                break;
            }
            case DRIVE_DRIVES: {
                this.apiProxy = this.getClient().drives();
                break;
            }
            case DRIVE_FILES: {
                this.apiProxy = this.getClient().files();
                break;
            }
            case DRIVE_PERMISSIONS: {
                this.apiProxy = this.getClient().permissions();
                break;
            }
            case DRIVE_REPLIES: {
                this.apiProxy = this.getClient().replies();
                break;
            }
            case DRIVE_REVISIONS: {
                this.apiProxy = this.getClient().revisions();
                break;
            }
            case DRIVE_TEAMDRIVES: {
                this.apiProxy = this.getClient().teamdrives();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid API name " + String.valueOf(this.apiName));
            }
        }
    }

    public Drive getClient() {
        return ((GoogleDriveComponent)this.getComponent()).getClient(this.configuration);
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        return this.apiProxy;
    }

    public GoogleDriveClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public void setClientFactory(GoogleDriveClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }
}

