/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.services.drive.Drive;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.drive.BatchGoogleDriveClientFactory;
import org.apache.camel.component.google.drive.GoogleDriveClientFactory;
import org.apache.camel.component.google.drive.GoogleDriveConfiguration;
import org.apache.camel.component.google.drive.GoogleDriveEndpoint;
import org.apache.camel.component.google.drive.internal.GoogleDriveApiCollection;
import org.apache.camel.component.google.drive.internal.GoogleDriveApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.component.AbstractApiComponent;
import org.apache.camel.util.component.ApiCollection;

public class GoogleDriveComponent
extends AbstractApiComponent<GoogleDriveApiName, GoogleDriveConfiguration, GoogleDriveApiCollection> {
    @Metadata(label="advanced")
    private Drive client;
    @Metadata(label="advanced")
    private GoogleDriveClientFactory clientFactory;

    public GoogleDriveComponent() {
        super(GoogleDriveEndpoint.class, GoogleDriveApiName.class, (ApiCollection)GoogleDriveApiCollection.getCollection());
    }

    public GoogleDriveComponent(CamelContext context) {
        super(context, GoogleDriveEndpoint.class, GoogleDriveApiName.class, (ApiCollection)GoogleDriveApiCollection.getCollection());
    }

    protected GoogleDriveApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return GoogleDriveApiName.fromValue(apiNameStr);
    }

    public Drive getClient(GoogleDriveConfiguration googleDriveConfiguration) {
        if (this.client == null) {
            this.client = this.getClientFactory().makeClient(googleDriveConfiguration.getClientId(), googleDriveConfiguration.getClientSecret(), googleDriveConfiguration.getScopes(), googleDriveConfiguration.getApplicationName(), googleDriveConfiguration.getRefreshToken(), googleDriveConfiguration.getAccessToken());
        }
        return this.client;
    }

    public GoogleDriveClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            if (ObjectHelper.isNotEmpty((Object)this.getCamelContext().getGlobalOption("http.proxyHost")) && ObjectHelper.isNotEmpty((Object)this.getCamelContext().getGlobalOption("http.proxyPort"))) {
                String host = this.getCamelContext().getGlobalOption("http.proxyHost");
                int port = Integer.parseInt(this.getCamelContext().getGlobalOption("http.proxyPort"));
                this.clientFactory = new BatchGoogleDriveClientFactory(host, port);
            } else {
                this.clientFactory = new BatchGoogleDriveClientFactory();
            }
        }
        return this.clientFactory;
    }

    public void setConfiguration(GoogleDriveConfiguration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public GoogleDriveConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new GoogleDriveConfiguration();
        }
        return (GoogleDriveConfiguration)super.getConfiguration();
    }

    public void setClientFactory(GoogleDriveClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    protected Endpoint createEndpoint(String uri, String methodName, GoogleDriveApiName apiName, GoogleDriveConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        GoogleDriveEndpoint endpoint = new GoogleDriveEndpoint(uri, this, apiName, methodName, endpointConfiguration);
        endpoint.setClientFactory(this.clientFactory);
        return endpoint;
    }
}

