/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.calendar;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.calendar.Calendar;
import java.io.File;
import java.util.Collection;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.calendar.GoogleCalendarClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchGoogleCalendarClientFactory
implements GoogleCalendarClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BatchGoogleCalendarClientFactory.class);
    private NetHttpTransport transport = new NetHttpTransport();
    private JacksonFactory jsonFactory = new JacksonFactory();

    @Override
    public Calendar makeClient(String clientId, String clientSecret, Collection<String> scopes, String applicationName, String refreshToken, String accessToken, String emailAddress, String p12FileName, String user) {
        boolean serviceAccount = false;
        if (null != emailAddress && !"".equals(emailAddress) && null != p12FileName && !"".equals(p12FileName)) {
            serviceAccount = true;
        }
        if (!(serviceAccount || clientId != null && clientSecret != null)) {
            throw new IllegalArgumentException("clientId and clientSecret are required to create Google Calendar client.");
        }
        try {
            Credential credential;
            if (serviceAccount) {
                credential = this.authorizeServiceAccount(emailAddress, p12FileName, scopes, user);
            } else {
                credential = this.authorize(clientId, clientSecret, scopes);
                if (refreshToken != null && !"".equals(refreshToken)) {
                    credential.setRefreshToken(refreshToken);
                }
                if (accessToken != null && !"".equals(accessToken)) {
                    credential.setAccessToken(accessToken);
                }
            }
            return new Calendar.Builder((HttpTransport)this.transport, (JsonFactory)this.jsonFactory, (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Could not create Google Calendar client.", (Throwable)e);
        }
    }

    private Credential authorize(String clientId, String clientSecret, Collection<String> scopes) {
        return new GoogleCredential.Builder().setJsonFactory((JsonFactory)this.jsonFactory).setTransport((HttpTransport)this.transport).setClientSecrets(clientId, clientSecret).build();
    }

    private Credential authorizeServiceAccount(String emailAddress, String p12FileName, Collection<String> scopes, String user) throws Exception {
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        GoogleCredential credential = new GoogleCredential.Builder().setTransport((HttpTransport)httpTransport).setJsonFactory((JsonFactory)this.jsonFactory).setServiceAccountId(emailAddress).setServiceAccountPrivateKeyFromP12File(new File(p12FileName)).setServiceAccountScopes(scopes).setServiceAccountUser(user).build();
        return credential;
    }
}

