/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery.sql;

import org.apache.camel.component.google.bigquery.GoogleBigQueryConnectionFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class GoogleBigQuerySQLConfiguration {
    @UriParam(description="ConnectionFactory to obtain connection to Bigquery Service. If non provided the default one will be used")
    private GoogleBigQueryConnectionFactory connectionFactory;
    @UriPath(label="common", description="Google Cloud Project Id")
    @Metadata(required="true")
    private String projectId;
    @UriPath(label="common", description="BigQuery standard SQL query")
    @Metadata(required="true")
    private String query;

    public void parseRemaining(String remaining) {
        int indexOfColon = remaining.indexOf(":");
        if (indexOfColon < 0) {
            throw new IllegalArgumentException("Google BigQuery Endpoint format \"projectId:query\"");
        }
        this.projectId = remaining.substring(0, indexOfColon);
        this.query = remaining.substring(indexOfColon + 1);
    }

    public GoogleBigQueryConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(GoogleBigQueryConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getQuery() {
        return this.query;
    }

    public GoogleBigQuerySQLConfiguration setQuery(String query) {
        this.query = query;
        return this;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public GoogleBigQuerySQLConfiguration setProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }
}

