/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.consumer;

import java.util.Queue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.service.GitHubService;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGitHubConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGitHubConsumer.class);
    private final GitHubEndpoint endpoint;
    private RepositoryService repositoryService;
    private Repository repository;

    protected AbstractGitHubConsumer(GitHubEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubRepositoryService");
        if (service != null) {
            LOG.debug("Using RepositoryService found in registry {}", (Object)service.getClass().getCanonicalName());
            this.repositoryService = (RepositoryService)service;
        } else {
            this.repositoryService = new RepositoryService();
        }
        this.initService((GitHubService)this.repositoryService);
        this.repository = this.repositoryService.getRepository(endpoint.getRepoOwner(), endpoint.getRepoName());
    }

    protected void initService(GitHubService service) {
        service.getClient().setOAuth2Token(this.endpoint.getOauthToken());
    }

    protected RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total;
        int answer = total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            LOG.debug("Limiting to maximum messages to poll {} as there were {} messages in this poll.", (Object)this.maxMessagesPerPoll, (Object)total);
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)exchanges.poll();
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            this.getProcessor().process(exchange);
        }
        return answer;
    }
}

