/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.consumer;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.consumer.AbstractGitHubConsumer;
import org.apache.camel.spi.Registry;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.service.GitHubService;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestConsumer
extends AbstractGitHubConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(PullRequestConsumer.class);
    private PullRequestService pullRequestService;
    private int lastOpenPullRequest;

    public PullRequestConsumer(GitHubEndpoint endpoint, Processor processor) throws Exception {
        super(endpoint, processor);
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubPullRequestService");
        if (service != null) {
            LOG.debug("Using PullRequestService found in registry {}", (Object)service.getClass().getCanonicalName());
            this.pullRequestService = (PullRequestService)service;
        } else {
            this.pullRequestService = new PullRequestService();
        }
        this.initService((GitHubService)this.pullRequestService);
        LOG.info("GitHub PullRequestConsumer: Indexing current pull requests...");
        List pullRequests = this.pullRequestService.getPullRequests((IRepositoryIdProvider)this.getRepository(), "open");
        if (!pullRequests.isEmpty()) {
            this.lastOpenPullRequest = ((PullRequest)pullRequests.get(0)).getNumber();
        }
    }

    @Override
    protected int poll() throws Exception {
        PullRequest pullRequest;
        List openPullRequests = this.pullRequestService.getPullRequests((IRepositoryIdProvider)this.getRepository(), "open");
        Stack<PullRequest> newPullRequests = new Stack<PullRequest>();
        Iterator iterator = openPullRequests.iterator();
        while (iterator.hasNext() && (pullRequest = (PullRequest)iterator.next()).getNumber() > this.lastOpenPullRequest) {
            newPullRequests.push(pullRequest);
        }
        if (!newPullRequests.isEmpty()) {
            this.lastOpenPullRequest = ((PullRequest)openPullRequests.get(0)).getNumber();
        }
        while (!newPullRequests.empty()) {
            PullRequest newPullRequest = (PullRequest)newPullRequests.pop();
            Exchange e = this.createExchange(true);
            e.getIn().setBody((Object)newPullRequest);
            e.getIn().setHeader("GitHubPullRequest", (Object)newPullRequest.getNumber());
            if (newPullRequest.getHead() != null) {
                e.getIn().setHeader("GitHubPullRequestHeadCommitSHA", (Object)newPullRequest.getHead().getSha());
            }
            this.getProcessor().process(e);
        }
        return newPullRequests.size();
    }
}

