/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.GitHubType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="github")
public class GitHubComponent
extends DefaultComponent {
    @Metadata(label="security", secret=true)
    private String oauthToken;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        GitHubEndpoint endpoint = new GitHubEndpoint(uri, this);
        endpoint.setOauthToken(this.oauthToken);
        this.setProperties((Endpoint)endpoint, parameters);
        String[] parts = remaining.split("/");
        if (parts.length >= 1) {
            String s = parts[0];
            GitHubType type = (GitHubType)((Object)this.getCamelContext().getTypeConverter().convertTo(GitHubType.class, (Object)s));
            endpoint.setType(type);
            if (parts.length > 1) {
                s = parts[1];
                endpoint.setBranchName(s);
            }
        }
        return endpoint;
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public void setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
    }
}

