/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.github.GitHubComponent;
import org.apache.camel.component.github.GitHubType;
import org.apache.camel.component.github.consumer.CommitConsumer;
import org.apache.camel.component.github.consumer.PullRequestCommentConsumer;
import org.apache.camel.component.github.consumer.PullRequestConsumer;
import org.apache.camel.component.github.consumer.TagConsumer;
import org.apache.camel.component.github.producer.ClosePullRequestProducer;
import org.apache.camel.component.github.producer.CreateIssueProducer;
import org.apache.camel.component.github.producer.GetCommitFileProducer;
import org.apache.camel.component.github.producer.PullRequestCommentProducer;
import org.apache.camel.component.github.producer.PullRequestFilesProducer;
import org.apache.camel.component.github.producer.PullRequestStateProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.15.0", scheme="github", title="GitHub", syntax="github:type/branchName", label="api,file")
public class GitHubEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required="true")
    private GitHubType type;
    @UriPath(label="consumer")
    private String branchName;
    @UriParam
    private String username;
    @UriParam
    private String password;
    @UriParam
    private String oauthToken;
    @UriParam
    @Metadata(required="true")
    private String repoOwner;
    @UriParam
    @Metadata(required="true")
    private String repoName;
    @UriParam(label="producer", enums="error,failure,pending,success")
    private String state;
    @UriParam(label="producer")
    private String targetUrl;
    @UriParam(label="producer")
    private String encoding;

    public GitHubEndpoint(String uri, GitHubComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        if (this.type == GitHubType.CLOSEPULLREQUEST) {
            return new ClosePullRequestProducer(this);
        }
        if (this.type == GitHubType.PULLREQUESTCOMMENT) {
            return new PullRequestCommentProducer(this);
        }
        if (this.type == GitHubType.PULLREQUESTSTATE) {
            return new PullRequestStateProducer(this);
        }
        if (this.type == GitHubType.PULLREQUESTFILES) {
            return new PullRequestFilesProducer(this);
        }
        if (this.type == GitHubType.GETCOMMITFILE) {
            return new GetCommitFileProducer(this);
        }
        if (this.type == GitHubType.CREATEISSUE) {
            return new CreateIssueProducer(this);
        }
        throw new IllegalArgumentException("Cannot create producer with type " + (Object)((Object)this.type));
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.type == GitHubType.COMMIT) {
            ObjectHelper.notEmpty((String)this.branchName, (String)"branchName", (Object)((Object)this));
            return new CommitConsumer(this, processor, this.branchName);
        }
        if (this.type == GitHubType.PULLREQUEST) {
            return new PullRequestConsumer(this, processor);
        }
        if (this.type == GitHubType.PULLREQUESTCOMMENT) {
            return new PullRequestCommentConsumer(this, processor);
        }
        if (this.type == GitHubType.TAG) {
            return new TagConsumer(this, processor);
        }
        throw new IllegalArgumentException("Cannot create consumer with type " + (Object)((Object)this.type));
    }

    public boolean isSingleton() {
        return true;
    }

    public GitHubType getType() {
        return this.type;
    }

    public void setType(GitHubType type) {
        this.type = type;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public void setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
    }

    public boolean hasOauth() {
        return this.oauthToken != null && this.oauthToken.length() > 0;
    }

    public String getRepoOwner() {
        return this.repoOwner;
    }

    public void setRepoOwner(String repoOwner) {
        this.repoOwner = repoOwner;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

