/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git.consumer;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.git.GitEndpoint;
import org.apache.camel.component.git.consumer.AbstractGitConsumer;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitCommitConsumer
extends AbstractGitConsumer {
    private List commitsConsumed = new ArrayList();

    public GitCommitConsumer(GitEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    protected int poll() throws Exception {
        int count = 0;
        Iterable commits = ObjectHelper.isNotEmpty((Object)((GitEndpoint)this.getEndpoint()).getBranchName()) ? this.getGit().log().add((AnyObjectId)this.getGit().getRepository().resolve(((GitEndpoint)this.getEndpoint()).getBranchName())).call() : this.getGit().log().all().call();
        for (RevCommit commit : commits) {
            if (this.commitsConsumed.contains(commit.getId())) continue;
            Exchange e = this.createExchange(true);
            e.getMessage().setBody((Object)commit.getFullMessage());
            e.getMessage().setHeader("CamelGitCommitId", (Object)commit.getId());
            e.getMessage().setHeader("CamelGitAuthorName", (Object)commit.getAuthorIdent().getName());
            e.getMessage().setHeader("CamelGitCommiterName", (Object)commit.getCommitterIdent().getName());
            e.getMessage().setHeader("CamelGitCommitTime", (Object)commit.getCommitTime());
            this.getProcessor().process(e);
            this.commitsConsumed.add(commit.getId());
            ++count;
        }
        return count;
    }
}

