/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.auth;

import com.google.gdata.client.authn.oauth.GoogleOAuthHelper;
import com.google.gdata.client.authn.oauth.GoogleOAuthParameters;
import com.google.gdata.client.authn.oauth.OAuthHelper;
import com.google.gdata.client.authn.oauth.OAuthHmacSha1Signer;
import com.google.gdata.client.authn.oauth.OAuthRsaSha1Signer;
import com.google.gdata.client.authn.oauth.OAuthSigner;
import java.security.PrivateKey;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.gae.auth.GAuthComponent;
import org.apache.camel.component.gae.auth.GAuthKeyLoader;
import org.apache.camel.component.gae.auth.GAuthProducer;
import org.apache.camel.component.gae.auth.GAuthService;
import org.apache.camel.component.gae.auth.GAuthServiceImpl;
import org.apache.camel.component.gae.bind.OutboundBinding;
import org.apache.camel.impl.DefaultEndpoint;

public class GAuthEndpoint
extends DefaultEndpoint {
    private OutboundBinding<GAuthEndpoint, GoogleOAuthParameters, GoogleOAuthParameters> authorizeBinding;
    private OutboundBinding<GAuthEndpoint, GoogleOAuthParameters, GoogleOAuthParameters> upgradeBinding;
    private Name name;
    private String callback;
    private String scope;
    private String consumerKey;
    private String consumerSecret;
    private GAuthKeyLoader keyLoader;
    private GAuthService service;
    private PrivateKey cachedKey;

    public GAuthEndpoint(String endpointUri, Component component, String name) {
        super(endpointUri, component);
        this.name = Name.valueOf(name.toUpperCase());
        this.service = new GAuthServiceImpl(this);
    }

    public OutboundBinding<GAuthEndpoint, GoogleOAuthParameters, GoogleOAuthParameters> getAuthorizeBinding() {
        return this.authorizeBinding;
    }

    public void setAuthorizeBinding(OutboundBinding<GAuthEndpoint, GoogleOAuthParameters, GoogleOAuthParameters> authorizeBinding) {
        this.authorizeBinding = authorizeBinding;
    }

    public OutboundBinding<GAuthEndpoint, GoogleOAuthParameters, GoogleOAuthParameters> getUpgradeBinding() {
        return this.upgradeBinding;
    }

    public void setUpgradeBinding(OutboundBinding<GAuthEndpoint, GoogleOAuthParameters, GoogleOAuthParameters> upgradeBinding) {
        this.upgradeBinding = upgradeBinding;
    }

    public GAuthComponent getComponent() {
        return (GAuthComponent)super.getComponent();
    }

    public Name getName() {
        return this.name;
    }

    public String getCallback() {
        return this.callback;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String services) {
        this.scope = services;
    }

    public String[] getScopeArray() {
        return this.getScope().split(",");
    }

    public String getConsumerKey() {
        if (this.consumerKey == null) {
            return this.getComponent().getConsumerKey();
        }
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        if (this.consumerSecret == null) {
            return this.getComponent().getConsumerSecret();
        }
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public GAuthKeyLoader getKeyLoader() {
        if (this.keyLoader == null) {
            return this.getComponent().getKeyLoader();
        }
        return this.keyLoader;
    }

    public void setKeyLoader(GAuthKeyLoader keyLoader) {
        this.keyLoader = keyLoader;
    }

    public GAuthService getService() {
        return this.service;
    }

    public void setService(GAuthService service) {
        this.service = service;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("consumption from gauth endpoint not supported");
    }

    public Producer createProducer() throws Exception {
        return new GAuthProducer(this);
    }

    public boolean isSingleton() {
        return true;
    }

    OAuthHelper newOAuthHelper() throws Exception {
        Object signer = null;
        signer = this.getKeyLoader() == null ? new OAuthHmacSha1Signer() : new OAuthRsaSha1Signer(this.getPrivateKey());
        return new GoogleOAuthHelper((OAuthSigner)signer);
    }

    private synchronized PrivateKey getPrivateKey() throws Exception {
        if (this.cachedKey == null) {
            this.cachedKey = this.getKeyLoader().loadPrivateKey();
        }
        return this.cachedKey;
    }

    public static enum Name {
        AUTHORIZE,
        UPGRADE;

    }
}

