/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.task;

import com.google.appengine.api.taskqueue.TaskOptions;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.gae.bind.InboundBinding;
import org.apache.camel.component.gae.bind.OutboundBinding;
import org.apache.camel.component.gae.task.GTaskEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTaskBinding
implements OutboundBinding<GTaskEndpoint, TaskOptions, Void>,
InboundBinding<GTaskEndpoint, HttpServletRequest, HttpServletResponse> {
    public static final String GTASK_QUEUE_NAME = "CamelGtaskQueueName";
    public static final String GTASK_TASK_NAME = "CamelGtaskTaskName";
    public static final String GTASK_RETRY_COUNT = "CamelGtaskRetryCount";
    static final String GAE_QUEUE_NAME = "X-AppEngine-QueueName";
    static final String GAE_TASK_NAME = "X-AppEngine-TaskName";
    static final String GAE_RETRY_COUNT = "X-AppEngine-TaskRetryCount";

    @Override
    public TaskOptions writeRequest(GTaskEndpoint endpoint, Exchange exchange, TaskOptions request) {
        TaskOptions answer = TaskOptions.Builder.withUrl((String)(this.getWorkerRoot(endpoint) + endpoint.getPath()));
        this.writeRequestHeaders(endpoint, exchange, answer);
        this.writeRequestBody(endpoint, exchange, answer);
        return answer;
    }

    @Override
    public Exchange readResponse(GTaskEndpoint endpoint, Exchange exchange, Void response) {
        throw new UnsupportedOperationException("gtask responses not supported");
    }

    @Override
    public Exchange readRequest(GTaskEndpoint endpoint, Exchange exchange, HttpServletRequest request) {
        this.readRequestHeaders(endpoint, exchange, request);
        return exchange;
    }

    @Override
    public HttpServletResponse writeResponse(GTaskEndpoint endpoint, Exchange exchange, HttpServletResponse response) {
        return response;
    }

    protected void writeRequestHeaders(GTaskEndpoint endpoint, Exchange exchange, TaskOptions request) {
        HeaderFilterStrategy strategy = endpoint.getHeaderFilterStrategy();
        for (String headerName : exchange.getIn().getHeaders().keySet()) {
            String headerValue = (String)exchange.getIn().getHeader(headerName, String.class);
            if (strategy == null || strategy.applyFilterToCamelHeaders(headerName, (Object)headerValue, exchange)) continue;
            request.header(headerName, headerValue);
        }
    }

    protected void readRequestHeaders(GTaskEndpoint endpoint, Exchange exchange, HttpServletRequest request) {
        String key;
        Message message = exchange.getIn();
        Object val = message.getHeader(key = GAE_QUEUE_NAME);
        if (val != null) {
            message.getHeaders().put(GTASK_QUEUE_NAME, val);
            message.getHeaders().remove(key);
        }
        if ((val = message.getHeader(key = GAE_TASK_NAME)) != null) {
            message.getHeaders().put(GTASK_TASK_NAME, val);
            message.getHeaders().remove(key);
        }
        if ((val = message.getHeader(key = GAE_RETRY_COUNT)) != null) {
            message.getHeaders().put(GTASK_RETRY_COUNT, Integer.parseInt(val.toString()));
            message.getHeaders().remove(key);
        }
        exchange.getIn().removeHeader("Accept-Encoding");
        exchange.getIn().removeHeader("Content-Encoding");
    }

    protected void writeRequestBody(GTaskEndpoint endpoint, Exchange exchange, TaskOptions request) {
        request.payload((byte[])exchange.getIn().getBody(byte[].class), "application/octet-stream");
    }

    protected String getWorkerRoot(GTaskEndpoint endpoint) {
        return "/" + endpoint.getWorkerRoot();
    }
}

