/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.auth;

import com.google.gdata.client.authn.oauth.GoogleOAuthParameters;
import com.google.gdata.client.authn.oauth.OAuthParameters;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.gae.auth.GAuthEndpoint;
import org.apache.camel.component.gae.bind.OutboundBinding;
import org.apache.camel.impl.DefaultProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAuthProducer
extends DefaultProducer {
    public GAuthProducer(GAuthEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public GAuthEndpoint getEndpoint() {
        return (GAuthEndpoint)super.getEndpoint();
    }

    public OutboundBinding<GAuthEndpoint, GoogleOAuthParameters, GoogleOAuthParameters> getAuthorizeBinding() {
        return this.getEndpoint().getAuthorizeBinding();
    }

    public OutboundBinding<GAuthEndpoint, GoogleOAuthParameters, GoogleOAuthParameters> getUpgradeBinding() {
        return this.getEndpoint().getUpgradeBinding();
    }

    public void process(Exchange exchange) throws Exception {
        if (this.getEndpoint().getName() == GAuthEndpoint.Name.AUTHORIZE) {
            GoogleOAuthParameters params = this.getAuthorizeBinding().writeRequest(this.getEndpoint(), exchange, null);
            this.getEndpoint().getService().getUnauthorizedRequestToken((OAuthParameters)params);
            this.getAuthorizeBinding().readResponse(this.getEndpoint(), exchange, params);
        } else {
            GoogleOAuthParameters params = this.getUpgradeBinding().writeRequest(this.getEndpoint(), exchange, null);
            this.getEndpoint().getService().getAccessToken((OAuthParameters)params);
            this.getUpgradeBinding().readResponse(this.getEndpoint(), exchange, params);
        }
    }
}

