/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.bind;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.gae.bind.InboundBinding;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpBindingInvocationHandler<E extends Endpoint, S, T>
implements InvocationHandler {
    private E endpoint;
    private HttpBinding httpBinding;
    private InboundBinding<E, S, T> inboundBinding;

    public HttpBindingInvocationHandler(E endpoint, HttpBinding httpBinding, InboundBinding<E, S, T> inboundBinding) {
        this.endpoint = endpoint;
        this.httpBinding = httpBinding;
        this.inboundBinding = inboundBinding;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = method.invoke((Object)this.httpBinding, args);
        if (method.getName().equals("readRequest") && args.length == 2) {
            HttpMessage message = (HttpMessage)args[1];
            message.getExchange().setIn((Message)message);
            this.inboundBinding.readRequest(this.endpoint, message.getExchange(), args[0]);
        } else if (method.getName().equals("writeResponse") && args.length == 2) {
            this.inboundBinding.writeResponse(this.endpoint, (Exchange)args[0], args[1]);
        }
        return result;
    }
}

