/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.http;

import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Producer;
import org.apache.camel.component.gae.bind.HttpBindingInvocationHandler;
import org.apache.camel.component.gae.bind.InboundBinding;
import org.apache.camel.component.gae.bind.OutboundBinding;
import org.apache.camel.component.gae.bind.OutboundBindingSupport;
import org.apache.camel.component.gae.http.GHttpProducer;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.servlet.ServletComponent;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.util.URISupport;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHttpEndpoint
extends ServletEndpoint
implements OutboundBindingSupport<GHttpEndpoint, HTTPRequest, HTTPResponse> {
    public static final String GHTTP_SCHEME = "ghttp";
    public static final String GHTTPS_SCHEME = "ghttps";
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    private URLFetchService urlFetchService;
    private OutboundBinding<GHttpEndpoint, HTTPRequest, HTTPResponse> outboundBinding;
    private InboundBinding<GHttpEndpoint, HttpServletRequest, HttpServletResponse> inboundBinding;

    public GHttpEndpoint(String endpointUri, ServletComponent component, URI httpUri, HttpClientParams params, HttpConnectionManager httpConnectionManager, HttpClientConfigurer clientConfigurer) throws URISyntaxException {
        super(endpointUri, component, httpUri, params, httpConnectionManager, clientConfigurer);
    }

    static URL getEndpointUrl(String uri, String query) throws Exception {
        Map parameters = null;
        URI uriObj = new URI(uri);
        parameters = query == null ? URISupport.parseParameters((URI)uriObj) : URISupport.parseQuery((String)query);
        uriObj = uriObj.getScheme().equals(GHTTPS_SCHEME) ? new URI("https:" + uriObj.getRawSchemeSpecificPart()) : new URI("http:" + uriObj.getRawSchemeSpecificPart());
        return URISupport.createRemainingURI((URI)uriObj, (Map)parameters).toURL();
    }

    public URL getEndpointUrl() throws Exception {
        return GHttpEndpoint.getEndpointUrl(this.getEndpointUri(), null);
    }

    public URLFetchService getUrlFetchService() {
        return this.urlFetchService;
    }

    public void setUrlFetchService(URLFetchService urlFetchService) {
        this.urlFetchService = urlFetchService;
    }

    @Override
    public OutboundBinding<GHttpEndpoint, HTTPRequest, HTTPResponse> getOutboundBinding() {
        return this.outboundBinding;
    }

    @Override
    public void setOutboundBinding(OutboundBinding<GHttpEndpoint, HTTPRequest, HTTPResponse> outboundBinding) {
        this.outboundBinding = outboundBinding;
    }

    public InboundBinding<GHttpEndpoint, HttpServletRequest, HttpServletResponse> getInboundBinding() {
        return this.inboundBinding;
    }

    public void setInboundBinding(InboundBinding<GHttpEndpoint, HttpServletRequest, HttpServletResponse> inboundBinding) {
        this.inboundBinding = inboundBinding;
    }

    public HttpBinding getBinding() {
        return (HttpBinding)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpBinding.class}, new HttpBindingInvocationHandler<GHttpEndpoint, HttpServletRequest, HttpServletResponse>(this, super.getBinding(), this.getInboundBinding()));
    }

    public Producer createProducer() throws Exception {
        return new GHttpProducer(this);
    }
}

