/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.mail;

import com.google.appengine.api.mail.MailService;
import com.google.appengine.api.mail.MailServiceFactory;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.gae.bind.OutboundBinding;
import org.apache.camel.component.gae.bind.OutboundBindingSupport;
import org.apache.camel.component.gae.mail.GMailProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="gmail", syntax="gmail:sender", producerOnly=true, label="cloud,mail")
public class GMailEndpoint
extends DefaultEndpoint
implements OutboundBindingSupport<GMailEndpoint, MailService.Message, Void> {
    private OutboundBinding<GMailEndpoint, MailService.Message, Void> outboundBinding;
    private MailService mailService;
    @UriPath
    @Metadata(required="true")
    private String sender;
    @UriParam
    private String subject;
    @UriParam
    private String to;
    @UriParam
    private String cc;
    @UriParam
    private String bcc;

    public GMailEndpoint(String endpointUri, Component component, String sender) {
        super(endpointUri, component);
        this.sender = sender;
        this.mailService = MailServiceFactory.getMailService();
    }

    @Override
    public OutboundBinding<GMailEndpoint, MailService.Message, Void> getOutboundBinding() {
        return this.outboundBinding;
    }

    @Override
    public void setOutboundBinding(OutboundBinding<GMailEndpoint, MailService.Message, Void> outboundBinding) {
        this.outboundBinding = outboundBinding;
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public String getSender() {
        return this.sender;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public String getBcc() {
        return this.bcc;
    }

    public void setBcc(String bcc) {
        this.bcc = bcc;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("consumption from gmail endpoint not supported");
    }

    public Producer createProducer() throws Exception {
        return new GMailProducer(this);
    }

    public boolean isSingleton() {
        return true;
    }
}

