/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.support.DefaultPollingConsumerPollStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteFilePollingConsumerPollStrategy
extends DefaultPollingConsumerPollStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteFilePollingConsumerPollStrategy.class);

    public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) throws Exception {
        block4: {
            RemoteFileConsumer rfc;
            if (consumer instanceof RemoteFileConsumer && (rfc = (RemoteFileConsumer)consumer).isRunAllowed()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Trying to recover by force disconnecting from remote server and re-connecting at next poll: {}", (Object)rfc.remoteServer());
                }
                try {
                    rfc.forceDisconnect();
                }
                catch (Exception t) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("Error occurred during force disconnecting from: {}. This exception will be ignored.", (Object)rfc.remoteServer(), (Object)t);
                }
            }
        }
        return super.rollback(consumer, endpoint, retryCounter, e);
    }
}

